/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.construct.Flow;
import org.mule.module.http.functional.requester.AbstractHttpRequestTestCase;

public class HttpRequestSendBodyTestCase
extends AbstractHttpRequestTestCase {
    protected String getConfigFile() {
        return "http-request-send-body-config.xml";
    }

    @Test
    public void sendBodyAutoSendsPayloadPost() throws Exception {
        this.assertNotEmptyBody("sendBodyAuto", "Test Message", "POST");
    }

    @Test
    public void sendBodyAutoIgnoresPayloadGet() throws Exception {
        this.assertEmptyBody("sendBodyAuto", "Test Message", "GET");
    }

    @Test
    public void sendBodyAutoIgnoresNullPayloadPost() throws Exception {
        this.assertEmptyBody("sendBodyAuto", null, "POST");
    }

    @Test
    public void sendBodyNeverIgnoresPayloadPost() throws Exception {
        this.assertEmptyBody("sendBodyNever", "Test Message", "POST");
    }

    @Test
    public void sendBodyNeverIgnoresNullPayloadPost() throws Exception {
        this.assertEmptyBody("sendBodyNever", null, "POST");
    }

    @Test
    public void sendBodyAlwaysSendsPayloadGet() throws Exception {
        this.assertNotEmptyBody("sendBodyAlways", "Test Message", "GET");
    }

    @Test
    public void sendBodyAlwaysIgnoresNullPayloadGet() throws Exception {
        this.assertEmptyBody("sendBodyAlways", null, "GET");
    }

    private void assertEmptyBody(String flowName, Object payload, String method) throws Exception {
        Flow flow = (Flow)this.getFlowConstruct(flowName);
        MuleEvent event = HttpRequestSendBodyTestCase.getTestEvent((Object)payload);
        event.getMessage().setInvocationProperty("method", (Object)method);
        flow.process(event);
        Assert.assertThat((Object)this.body, (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertThat((Object)this.headers.containsKey((Object)"Content-Length"), (Matcher)Is.is((Object)false));
    }

    private void assertNotEmptyBody(String flowName, Object payload, String method) throws Exception {
        Flow flow = (Flow)this.getFlowConstruct(flowName);
        MuleEvent event = HttpRequestSendBodyTestCase.getTestEvent((Object)payload);
        event.getMessage().setInvocationProperty("method", (Object)method);
        flow.process(event);
        Assert.assertThat((Object)this.body, (Matcher)CoreMatchers.equalTo((Object)"Test Message"));
        Assert.assertThat((Object)this.headers.containsKey((Object)"Content-Length"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.getFirstReceivedHeader("Content-Length"), (Matcher)Is.is((Object)String.valueOf("Test Message".length())));
    }
}

