/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEvent;
import org.mule.api.MuleEventContext;
import org.mule.construct.Flow;
import org.mule.module.http.api.HttpConstants;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.util.IOUtils;

@RunWith(value=Parameterized.class)
public class HttpRequestProxyTlsTestCase
extends FunctionalTestCase {
    private static final String OK_RESPONSE = "OK";
    private static final String PATH = "/test?key=value";
    @Rule
    public DynamicPort proxyPort = new DynamicPort("proxyPort");
    @Rule
    public DynamicPort httpPort = new DynamicPort("httpPort");
    @Rule
    public SystemProperty keyStorePathProperty;
    @Rule
    public SystemProperty trustStorePathProperty;
    private MockProxyServer proxyServer = new MockProxyServer(this.proxyPort.getNumber(), this.httpPort.getNumber());
    private String requestURI;
    private String requestPayload;
    private String requestHost;

    public HttpRequestProxyTlsTestCase(String keyStorePath, String trustStorePath, String requestHost) {
        this.keyStorePathProperty = new SystemProperty("keyStorePath", keyStorePath);
        this.trustStorePathProperty = new SystemProperty("trustStorePath", trustStorePath);
        this.requestHost = requestHost;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"tls/ssltest-keystore-with-test-hostname.jks", "tls/ssltest-truststore-with-test-hostname.jks", "test"}, {"tls/ssltest-keystore.jks", "tls/ssltest-cacerts.jks", "localhost"});
    }

    protected String getConfigFile() {
        return "http-request-proxy-tls-config.xml";
    }

    @Test
    public void requestIsSentCorrectlyThroughHttpsProxy() throws Exception {
        this.getFunctionalTestComponent("serverFlow").setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                HttpRequestProxyTlsTestCase.this.requestPayload = context.getMessage().getPayloadAsString();
                HttpRequestProxyTlsTestCase.this.requestURI = (String)context.getMessage().getInboundProperty("http.request.uri");
            }
        });
        this.proxyServer.start();
        Flow flow = (Flow)this.getFlowConstruct("clientFlow");
        MuleEvent event = HttpRequestProxyTlsTestCase.getTestEvent((Object)"Test Message");
        event.setFlowVariable("host", (Object)this.requestHost);
        event.setFlowVariable("path", (Object)PATH);
        event = flow.process(event);
        Assert.assertThat((Object)this.requestPayload, (Matcher)CoreMatchers.equalTo((Object)"Test Message"));
        Assert.assertThat((Object)this.requestURI, (Matcher)CoreMatchers.equalTo((Object)PATH));
        Assert.assertThat((Object)event.getMessage().getInboundProperty("http.status"), (Matcher)CoreMatchers.equalTo((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        Assert.assertThat((Object)event.getMessage().getPayloadAsString(), (Matcher)CoreMatchers.equalTo((Object)OK_RESPONSE));
        this.proxyServer.stop();
    }

    private static class MockProxyServer {
        private static final String PROXY_RESPONSE = "HTTP/1.1 200 Connection established\r\n\r\n";
        private int proxyServerPort;
        private int serverPort;
        private ServerSocket serverSocket;
        private Thread serverThread;

        public MockProxyServer(int proxyServerPort, int serverPort) {
            this.proxyServerPort = proxyServerPort;
            this.serverPort = serverPort;
        }

        public void start() throws Exception {
            this.serverSocket = new ServerSocket(this.proxyServerPort);
            this.serverThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Socket clientSocket = MockProxyServer.this.serverSocket.accept();
                        MockProxyServer.this.handleRequest(clientSocket);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            this.serverThread.start();
        }

        public void stop() throws Exception {
            this.serverSocket.close();
            this.serverThread.join();
        }

        private void handleRequest(final Socket clientSocket) throws Exception {
            BufferedReader reader = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()), 1);
            while (reader.readLine().trim().isEmpty()) {
            }
            OutputStream os = clientSocket.getOutputStream();
            os.write(PROXY_RESPONSE.getBytes());
            os.flush();
            final Socket server = new Socket("localhost", this.serverPort);
            Thread responseThread = new Thread(){

                @Override
                public void run() {
                    try {
                        IOUtils.copy((InputStream)server.getInputStream(), (OutputStream)clientSocket.getOutputStream());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            responseThread.start();
            IOUtils.copy((InputStream)clientSocket.getInputStream(), (OutputStream)server.getOutputStream());
            responseThread.join();
        }
    }
}

