/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.MessagingException;
import org.mule.construct.Flow;
import org.mule.module.http.api.requester.proxy.ProxyConfig;
import org.mule.module.http.internal.request.DefaultHttpRequester;
import org.mule.module.http.internal.request.NtlmProxyConfig;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.concurrent.Latch;

@RunWith(value=Parameterized.class)
public class HttpRequestProxyConfigTestCase
extends FunctionalTestCase {
    private static final String PROXY_HOST = "localhost";
    private static final String PROXY_USERNAME = "theUsername";
    private static final String PROXY_PASSWORD = "thePassword";
    private static final String PROXY_NTLM_DOMAIN = "theNtlmDomain";
    @Rule
    public DynamicPort proxyPort = new DynamicPort("proxyPort");
    @Rule
    public DynamicPort httpPort = new DynamicPort("httpPort");
    private Thread mockProxyAcceptor;
    private Latch latch = new Latch();
    private Latch proxyReadyLatch = new Latch();
    @Parameterized.Parameter(value=0)
    public String flowName;
    @Parameterized.Parameter(value=1)
    public ProxyType proxyType;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"refAnonymousProxy", ProxyType.ANONYMOUS}, {"innerAnonymousProxy", ProxyType.ANONYMOUS}, {"refUserPassProxy", ProxyType.USER_PASS}, {"innerUserPassProxy", ProxyType.USER_PASS}, {"refNtlmProxy", ProxyType.NTLM}, {"innerNtlmProxy", ProxyType.NTLM});
    }

    protected String getConfigFile() {
        return "http-request-proxy-config.xml";
    }

    @Before
    public void startMockProxy() throws IOException, InterruptedException {
        this.mockProxyAcceptor = new MockProxy();
        this.mockProxyAcceptor.start();
        this.proxyReadyLatch.await();
        Thread.yield();
    }

    @After
    public void stopMockProxy() throws Exception {
        this.mockProxyAcceptor.join();
    }

    @Test
    public void testProxy() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct(this.flowName);
        this.checkProxyConfig(flow);
        this.ensureRequestGoesThroughProxy(flow);
    }

    private void checkProxyConfig(Flow flow) {
        DefaultHttpRequester httpRequester = (DefaultHttpRequester)flow.getMessageProcessors().get(0);
        ProxyConfig proxyConfig = httpRequester.getConfig().getProxyConfig();
        Assert.assertThat((Object)proxyConfig.getHost(), (Matcher)Matchers.is((Object)PROXY_HOST));
        Assert.assertThat((Object)proxyConfig.getPort(), (Matcher)Matchers.is((Object)Integer.valueOf(this.proxyPort.getValue())));
        if (this.proxyType == ProxyType.USER_PASS || this.proxyType == ProxyType.NTLM) {
            Assert.assertThat((Object)proxyConfig.getUsername(), (Matcher)Matchers.is((Object)PROXY_USERNAME));
            Assert.assertThat((Object)proxyConfig.getPassword(), (Matcher)Matchers.is((Object)PROXY_PASSWORD));
            if (this.proxyType == ProxyType.NTLM) {
                Assert.assertThat((Object)proxyConfig, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(NtlmProxyConfig.class)));
                Assert.assertThat((Object)((NtlmProxyConfig)proxyConfig).getNtlmDomain(), (Matcher)Matchers.is((Object)PROXY_NTLM_DOMAIN));
            }
        }
    }

    private void ensureRequestGoesThroughProxy(Flow flow) throws Exception {
        try {
            flow.process(HttpRequestProxyConfigTestCase.getTestEvent((Object)"Test Message"));
            TestCase.fail((String)"Request should go through the proxy.");
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)e.getCauseException(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(IOException.class)));
            Assert.assertThat((Object)e.getCauseException().getMessage(), (Matcher)Matchers.is((Object)"Remotely closed"));
        }
        this.latch.await(1L, TimeUnit.SECONDS);
    }

    private class MockProxy
    extends Thread {
        private MockProxy() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ServerSocket serverSocket = null;
            try {
                serverSocket = new ServerSocket(Integer.parseInt(HttpRequestProxyConfigTestCase.this.proxyPort.getValue()));
                HttpRequestProxyConfigTestCase.this.proxyReadyLatch.countDown();
                serverSocket.accept().close();
                HttpRequestProxyConfigTestCase.this.latch.release();
            }
            catch (IOException iOException) {
            }
            finally {
                if (serverSocket != null) {
                    try {
                        serverSocket.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private static enum ProxyType {
        ANONYMOUS,
        USER_PASS,
        NTLM;

    }
}

