/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.construct.Flow;
import org.mule.module.http.functional.requester.AbstractHttpRequestTestCase;

public class HttpRequestPathsTestCase
extends AbstractHttpRequestTestCase {
    protected String getConfigFile() {
        return "http-request-paths-config.xml";
    }

    @Test
    public void emptyPathWithoutBasePath() throws Exception {
        this.assertRequestUri("requestWithoutBasePath", "", "", "/");
    }

    @Test
    public void rootPathWithoutBasePath() throws Exception {
        this.assertRequestUri("requestWithoutBasePath", "", "/", "/");
    }

    @Test
    public void customPathNoSlashWithoutBasePath() throws Exception {
        this.assertRequestUri("requestWithoutBasePath", "", "testPath", "/testPath");
    }

    @Test
    public void customPathWithSlashWithoutBasePath() throws Exception {
        this.assertRequestUri("requestWithoutBasePath", "", "/testPath", "/testPath");
    }

    @Test
    public void emptyPathWithBasePathNoSlash() throws Exception {
        this.assertRequestUri("requestWithBasePath", "basePath", "", "/basePath");
    }

    @Test
    public void rootPathWithBasePathNoSlash() throws Exception {
        this.assertRequestUri("requestWithBasePath", "basePath", "/", "/basePath/");
    }

    @Test
    public void customPathNoSlashWitBasePathNoSlash() throws Exception {
        this.assertRequestUri("requestWithBasePath", "basePath", "testPath", "/basePath/testPath");
    }

    @Test
    public void customPathWithSlashWithBasePathNoSlash() throws Exception {
        this.assertRequestUri("requestWithBasePath", "basePath", "/testPath", "/basePath/testPath");
    }

    @Test
    public void emptyPathWithBasePathWithSlash() throws Exception {
        this.assertRequestUri("requestWithBasePath", "basePath/", "", "/basePath/");
    }

    @Test
    public void rootPathWithBasePathWithSlash() throws Exception {
        this.assertRequestUri("requestWithBasePath", "basePath/", "/", "/basePath/");
    }

    @Test
    public void customPathNoSlashWitBasePathWithSlash() throws Exception {
        this.assertRequestUri("requestWithBasePath", "basePath/", "testPath", "/basePath/testPath");
    }

    @Test
    public void customPathWithSlashWithBasePathWithSlash() throws Exception {
        this.assertRequestUri("requestWithBasePath", "basePath/", "/testPath", "/basePath/testPath");
    }

    @Test
    public void customPathWithSpaceAndEncodedCharacter() throws Exception {
        this.assertRequestUri("requestWithBasePath", "base Path%25", "test Path%25?k1=v%25&k2=v2", "/base%20Path%25/test%20Path%25?k1=v%25&k2=v2");
    }

    private void assertRequestUri(String flowName, String basePath, String requestPath, String expectedUri) throws Exception {
        Flow flow = (Flow)this.getFlowConstruct(flowName);
        MuleEvent event = HttpRequestPathsTestCase.getTestEvent((Object)"Test Message");
        event.getMessage().setInvocationProperty("basePath", (Object)basePath);
        event.getMessage().setInvocationProperty("requestPath", (Object)requestPath);
        flow.process(event);
        Assert.assertThat((Object)this.uri, (Matcher)CoreMatchers.equalTo((Object)expectedUri));
    }
}

