/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.MultiPartInputStreamParser;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.construct.Flow;
import org.mule.message.ds.ByteArrayDataSource;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.functional.requester.AbstractHttpRequestTestCase;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.util.IOUtils;

public class HttpRequestOutboundAttachmentsTestCase
extends AbstractHttpRequestTestCase {
    private static final String TEST_FILE_NAME = "auth/realm.properties";
    private static final String TEST_PART_NAME = "partName";
    @Rule
    public SystemProperty sendBufferSize = new SystemProperty("sendBufferSize", "128");
    private Collection<Part> parts;
    private String requestContentType;

    protected String getConfigFile() {
        return "http-request-outbound-attachments-config.xml";
    }

    @Override
    protected boolean enableHttps() {
        return true;
    }

    @Test
    public void payloadIsIgnoredWhenSendingOutboundAttachments() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("requestFlow");
        MuleEvent event = HttpRequestOutboundAttachmentsTestCase.getTestEvent((Object)"Test Message");
        event.getMessage().addOutboundAttachment("attachment1", (Object)"Contents 1", "text/plain");
        event.getMessage().addOutboundAttachment("attachment2", (Object)"Contents 2", "text/html");
        flow.process(event);
        Assert.assertThat((Object)this.requestContentType, (Matcher)CoreMatchers.startsWith((String)"multipart/form-data; boundary="));
        Assert.assertThat((Object)this.parts.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        this.assertPart("attachment1", "text/plain", "Contents 1");
        this.assertPart("attachment2", "text/html", "Contents 2");
    }

    @Test
    public void outboundAttachmentsCustomContentType() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("requestFlow");
        MuleEvent event = HttpRequestOutboundAttachmentsTestCase.getTestEvent((Object)"Test Message");
        event.getMessage().addOutboundAttachment("attachment1", (Object)"Contents 1", "text/plain");
        event.getMessage().addOutboundAttachment("attachment2", (Object)"Contents 2", "text/html");
        event.getMessage().setOutboundProperty("Content-Type", (Object)"multipart/form-data2");
        flow.process(event);
        Assert.assertThat((Object)this.requestContentType, (Matcher)CoreMatchers.startsWith((String)"multipart/form-data2; boundary="));
        Assert.assertThat((Object)this.parts.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        this.assertPart("attachment1", "text/plain", "Contents 1");
        this.assertPart("attachment2", "text/html", "Contents 2");
    }

    @Test
    public void fileOutboundAttachmentSetsContentDispositionWithFileName() throws Exception {
        MuleEvent event = HttpRequestOutboundAttachmentsTestCase.getTestEvent((Object)"Test Message");
        File file = new File(IOUtils.getResourceAsUrl((String)TEST_FILE_NAME, ((Object)((Object)this)).getClass()).getPath());
        DataHandler dataHandler = new DataHandler((DataSource)new FileDataSource(file));
        event.getMessage().addOutboundAttachment(TEST_PART_NAME, dataHandler);
        Flow flow = (Flow)this.getFlowConstruct("requestFlow");
        flow.process(event);
        Part part = this.getPart(TEST_PART_NAME);
        this.assertFormDataContentDisposition(part, TEST_PART_NAME, TEST_FILE_NAME.substring(5));
    }

    @Test
    public void byteArrayOutboundAttachmentSetsContentDispositionWithFileName() throws Exception {
        MuleEvent event = HttpRequestOutboundAttachmentsTestCase.getTestEvent((Object)"Test Message");
        DataHandler dataHandler = new DataHandler((DataSource)new ByteArrayDataSource("Test Message".getBytes(), "text/plain", TEST_FILE_NAME));
        event.getMessage().addOutboundAttachment(TEST_PART_NAME, dataHandler);
        Flow flow = (Flow)this.getFlowConstruct("requestFlow");
        flow.process(event);
        Part part = this.getPart(TEST_PART_NAME);
        this.assertFormDataContentDisposition(part, TEST_PART_NAME, TEST_FILE_NAME);
    }

    @Test
    public void stringOutboundAttachmentSetsContentDispositionWithoutFileName() throws Exception {
        MuleEvent event = HttpRequestOutboundAttachmentsTestCase.getTestEvent((Object)"Test Message");
        event.getMessage().addOutboundAttachment(TEST_PART_NAME, (Object)"Test Message", "text/plain");
        Flow flow = (Flow)this.getFlowConstruct("requestFlow");
        flow.process(event);
        Part part = this.getPart(TEST_PART_NAME);
        this.assertFormDataContentDisposition(part, TEST_PART_NAME, null);
    }

    @Test
    public void sendingAttachmentBiggerThanAsyncWriteQueueSizeWorksOverHttps() throws Exception {
        MuleEvent event = HttpRequestOutboundAttachmentsTestCase.getTestEvent((Object)"Test Message");
        int maxAsyncWriteQueueSize = Integer.valueOf(this.sendBufferSize.getValue()) * 4;
        event.getMessage().addOutboundAttachment(TEST_PART_NAME, (Object)new byte[maxAsyncWriteQueueSize * 2], "text/plain");
        Flow flow = (Flow)this.getFlowConstruct("requestFlowTls");
        MuleEvent response = flow.process(event);
        Assert.assertThat((Object)((Integer)response.getMessage().getInboundProperty("http.status")), (Matcher)CoreMatchers.equalTo((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
    }

    private void assertPart(String name, String expectedContentType, String expectedBody) throws Exception {
        Part part = this.getPart(name);
        Assert.assertThat((Object)part, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)part.getContentType(), (Matcher)CoreMatchers.startsWith((String)expectedContentType));
        Assert.assertThat((Object)IOUtils.toString((InputStream)part.getInputStream()), (Matcher)CoreMatchers.equalTo((Object)expectedBody));
    }

    private void assertFormDataContentDisposition(Part part, String expectedName, String expectedFileName) {
        String expected = String.format("form-data; name=\"%s\"", expectedName);
        if (expectedFileName != null) {
            expected = expected + String.format("; filename=\"%s\"", expectedFileName);
        }
        Assert.assertThat((Object)part.getHeader("Content-Disposition"), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    private Part getPart(String name) {
        for (Part part : this.parts) {
            if (!part.getName().equals(name)) continue;
            return part;
        }
        return null;
    }

    @Override
    protected void handleRequest(Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.requestContentType = request.getHeader("Content-Type");
        MultiPartInputStreamParser inputStreamParser = new MultiPartInputStreamParser((InputStream)request.getInputStream(), request.getContentType(), null, null);
        try {
            this.parts = inputStreamParser.getParts();
        }
        catch (ServletException e) {
            throw new IOException(e);
        }
        response.setContentType("text/html");
        response.setStatus(200);
        response.getWriter().print("<h1>Response</h1>");
    }
}

