/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.module.http.functional.requester.AbstractHttpRequestTestCase;

public class HttpRequestMultipartTestCase
extends AbstractHttpRequestTestCase {
    private static final String BOUNDARY = "bec89590-35fe-11e5-a966-de100cec9c0d";
    private static final String CONTENT_DISPOSITION_HEADER = "Content-Disposition: form-data; name=\"partName\"\r\n";
    private static final String MULTIPART_FORMAT = "--%1$s\r\n %2$sContent-Type: text/plain\n\r\ntest\r\n--%1$s--\r\n";
    private static final String CONTENT_DISPOSITION_PATH = "/contentDisposition";

    protected String getConfigFile() {
        return "http-request-multipart-config.xml";
    }

    @Override
    protected void handleRequest(Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setHeader("Content-Type", String.format("multipart/form-data; boundary=%s", BOUNDARY));
        response.setStatus(200);
        this.extractBaseRequestParts(baseRequest);
        String contentDispositionHeader = baseRequest.getUri().getPath().equals(CONTENT_DISPOSITION_PATH) ? CONTENT_DISPOSITION_HEADER : "";
        response.getWriter().print(String.format(MULTIPART_FORMAT, BOUNDARY, contentDispositionHeader));
        baseRequest.setHandled(true);
    }

    @Test
    public void getMultipartContentWithContentDisposition() throws Exception {
        this.testWithPath(CONTENT_DISPOSITION_PATH);
    }

    @Test
    public void getMultipartContentWithoutContentDisposition() throws Exception {
        this.testWithPath("/");
    }

    private void testWithPath(String path) throws Exception {
        MuleEvent testEvent = HttpRequestMultipartTestCase.getTestEvent(null);
        testEvent.getMessage().setInvocationProperty("requestPath", (Object)path);
        MuleEvent response = this.runFlow("requestFlow", testEvent);
        Assert.assertThat((Object)response.getMessage().getInboundAttachmentNames().size(), (Matcher)Matchers.is((Object)1));
    }
}

