/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.TestCase;
import org.eclipse.jetty.server.Request;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.construct.Flow;
import org.mule.module.http.functional.requester.AbstractHttpRequestTestCase;
import org.mule.util.concurrent.Latch;

public class HttpRequestMaxConnectionsTestCase
extends AbstractHttpRequestTestCase {
    private static final int SMALL_RESPONSE_TIMEOUT = 1;
    private Latch messageArrived = new Latch();
    private Latch messageHold = new Latch();

    protected String getConfigFile() {
        return "http-request-max-connections-config.xml";
    }

    @Test
    public void maxConnections() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("limitedConnections");
        Thread t1 = this.processAsynchronously(flow);
        this.messageArrived.await();
        try {
            flow.process(this.createEvent(1));
            TestCase.fail((String)"Max connections should be reached.");
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(IOException.class));
        }
        this.messageHold.release();
        t1.join();
    }

    private Thread processAsynchronously(final Flow flow) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    flow.process(HttpRequestMaxConnectionsTestCase.this.createEvent(5000));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        thread.start();
        return thread;
    }

    private MuleEvent createEvent(int timeout) throws Exception {
        MuleEvent event = HttpRequestMaxConnectionsTestCase.getTestEvent((Object)"Test Message");
        event.setTimeout(timeout);
        return event;
    }

    @Override
    protected void handleRequest(Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        super.handleRequest(baseRequest, request, response);
        this.messageArrived.release();
        try {
            this.messageHold.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

