/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpRequestLaxContentTypeTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort httpPort = new DynamicPort("httpPort");

    protected String getConfigFile() {
        return "http-request-lax-content-type-config.xml";
    }

    @Test
    public void sendsInvalidContentTypeOnRequest() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        String url = String.format("http://localhost:%s/requestClientInvalid", this.httpPort.getNumber());
        MuleMessage response = client.send(url, (Object)"Test Message", null);
        this.assertNoContentTypeProperty(response);
        MatcherAssert.assertThat((Object)response.getPayloadAsString(), (Matcher)Matchers.equalTo((Object)"invalidMimeType"));
    }

    private void assertNoContentTypeProperty(MuleMessage response) {
        MatcherAssert.assertThat((Object)response.getInboundPropertyNames(), (Matcher)CoreMatchers.not((Matcher)Matchers.hasItem((Matcher)Matchers.equalToIgnoringCase((String)"Content-Type"))));
    }
}

