/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import javax.activation.DataHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.MultiPartWriter;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.construct.Flow;
import org.mule.module.http.functional.requester.AbstractHttpRequestTestCase;
import org.mule.transport.NullPayload;

public class HttpRequestInboundAttachmentsTestCase
extends AbstractHttpRequestTestCase {
    protected String getConfigFile() {
        return "http-request-inbound-attachments-config.xml";
    }

    @Test
    public void processInboundAttachments() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("requestFlow");
        MuleEvent event = flow.process(HttpRequestInboundAttachmentsTestCase.getTestEvent((Object)"Test Message"));
        Assert.assertThat((Object)event.getMessage().getPayload(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NullPayload.class)));
        Assert.assertThat((Object)event.getMessage().getInboundAttachmentNames().size(), (Matcher)CoreMatchers.is((Object)2));
        this.assertAttachment(event.getMessage(), "partName1", "Test part 1", "text/plain");
        this.assertAttachment(event.getMessage(), "partName2", "Test part 2", "text/html");
    }

    private void assertAttachment(MuleMessage message, String attachmentName, String attachmentContents, String contentType) throws IOException {
        Assert.assertTrue((boolean)message.getInboundAttachmentNames().contains(attachmentName));
        DataHandler handler = message.getInboundAttachment(attachmentName);
        Assert.assertThat((Object)handler.getContentType(), (Matcher)CoreMatchers.equalTo((Object)contentType));
        Assert.assertThat((Object)IOUtils.toString((InputStream)handler.getInputStream()), (Matcher)CoreMatchers.equalTo((Object)attachmentContents));
    }

    @Override
    protected void handleRequest(Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        MultiPartWriter multiPartWriter = new MultiPartWriter((Writer)response.getWriter());
        response.setContentType("multipart/form-data; boundary=" + multiPartWriter.getBoundary());
        response.setStatus(200);
        multiPartWriter.startPart("text/plain", new String[]{"Content-Disposition: form-data; name=\"partName1\""});
        multiPartWriter.write("Test part 1");
        multiPartWriter.endPart();
        multiPartWriter.startPart("text/html", new String[]{"Content-Disposition: form-data; name=\"partName2\""});
        multiPartWriter.write("Test part 2");
        multiPartWriter.endPart();
        multiPartWriter.close();
    }
}

