/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.construct.Flow;
import org.mule.module.http.functional.requester.AbstractHttpRequestTestCase;
import org.mule.tck.junit4.rule.SystemProperty;

public class HttpRequestHeadersTestCase
extends AbstractHttpRequestTestCase {
    @Rule
    public SystemProperty host = new SystemProperty("host", "localhost");
    @Rule
    public SystemProperty encoding = new SystemProperty("encoding", "chunked");

    protected String getConfigFile() {
        return "http-request-headers-config.xml";
    }

    @Test
    public void sendsHeadersFromList() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("headerList");
        MuleEvent event = HttpRequestHeadersTestCase.getTestEvent((Object)"Test Message");
        event.getMessage().setInvocationProperty("headerName", (Object)"testName2");
        event.getMessage().setInvocationProperty("headerValue", (Object)"testValue2");
        flow.process(event);
        Assert.assertThat((Object)this.getFirstReceivedHeader("testName1"), (Matcher)CoreMatchers.equalTo((Object)"testValue1"));
        Assert.assertThat((Object)this.getFirstReceivedHeader("testName2"), (Matcher)CoreMatchers.equalTo((Object)"testValue2"));
    }

    @Test
    public void sendsHeadersFromMap() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("headerMap");
        MuleEvent event = HttpRequestHeadersTestCase.getTestEvent((Object)"Test Message");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("testName1", "testValue1");
        params.put("testName2", "testValue2");
        event.getMessage().setInvocationProperty("headers", params);
        flow.process(event);
        Assert.assertThat((Object)this.getFirstReceivedHeader("testName1"), (Matcher)CoreMatchers.equalTo((Object)"testValue1"));
        Assert.assertThat((Object)this.getFirstReceivedHeader("testName2"), (Matcher)CoreMatchers.equalTo((Object)"testValue2"));
    }

    @Test
    public void overridesHeaders() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("headerOverride");
        MuleEvent event = HttpRequestHeadersTestCase.getTestEvent((Object)"Test Message");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("testName1", "testValueNew");
        params.put("testName2", "testValue2");
        event.getMessage().setInvocationProperty("headers", params);
        flow.process(event);
        Collection values = this.headers.get((Object)"testName1");
        Assert.assertThat((Object)values, (Matcher)Matchers.containsInAnyOrder((Object[])Arrays.asList("testValue1", "testValueNew").toArray(new String[2])));
        Assert.assertThat((Object)this.getFirstReceivedHeader("testName2"), (Matcher)CoreMatchers.equalTo((Object)"testValue2"));
    }

    @Test
    public void sendsOutboundPropertiesAsHeaders() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("headerMap");
        MuleEvent event = HttpRequestHeadersTestCase.getTestEvent((Object)"Test Message");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("testName1", "testValue1");
        event.getMessage().setInvocationProperty("headers", params);
        event.getMessage().setOutboundProperty("testName2", (Object)"testValue2");
        flow.process(event);
        Assert.assertThat((Object)this.getFirstReceivedHeader("testName1"), (Matcher)CoreMatchers.equalTo((Object)"testValue1"));
        Assert.assertThat((Object)this.getFirstReceivedHeader("testName2"), (Matcher)CoreMatchers.equalTo((Object)"testValue2"));
    }

    @Test
    public void allowsUserAgentOverride() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("headerMap");
        MuleEvent event = HttpRequestHeadersTestCase.getTestEvent((Object)"Test Message");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("User-Agent", "TEST");
        event.getMessage().setInvocationProperty("headers", params);
        flow.process(event);
        Assert.assertThat((Object)this.getFirstReceivedHeader("User-Agent"), (Matcher)CoreMatchers.equalTo((Object)"TEST"));
    }

    @Test
    public void ignoresHttpOutboundPropertiesButAcceptsHeaders() throws Exception {
        MuleEvent event = HttpRequestHeadersTestCase.getTestEvent((Object)"Test Message");
        event.getMessage().setOutboundProperty("http.listener.path", (Object)"listenerPath");
        this.processEventInFlow(event, "httpHeaders");
        Assert.assertThat((Object)this.getFirstReceivedHeader("http.scheme"), (Matcher)Matchers.is((Object)"testValue1"));
        Assert.assertThat((Object)this.headers.asMap(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"http.listener.path")));
    }

    @Test
    public void acceptsConnectionHeader() throws Exception {
        this.processEventInFlow(HttpRequestHeadersTestCase.getTestEvent((Object)"Test Message"), "connectionHeader");
        Assert.assertThat((Object)this.getFirstReceivedHeader("Connection"), (Matcher)Matchers.is((Object)"close"));
    }

    @Test
    public void ignoresConnectionOutboundProperty() throws Exception {
        MuleEvent event = HttpRequestHeadersTestCase.getTestEvent((Object)"Test Message");
        event.getMessage().setOutboundProperty("Connection", (Object)"close");
        this.processEventInFlow(event, "outboundProperties");
        Assert.assertThat((Object)this.getFirstReceivedHeader("Connection"), (Matcher)Matchers.is((Matcher)Matchers.not((Object)"close")));
    }

    @Test
    public void acceptsHostHeader() throws Exception {
        this.processEventInFlow(HttpRequestHeadersTestCase.getTestEvent((Object)"Test Message"), "hostHeader");
        Assert.assertThat((Object)this.getFirstReceivedHeader("Host"), (Matcher)Matchers.is((Object)this.host.getValue()));
    }

    @Test
    public void ignoresHostOutboundProperty() throws Exception {
        MuleEvent event = HttpRequestHeadersTestCase.getTestEvent((Object)"Test Message");
        event.getMessage().setOutboundProperty("Host", (Object)this.host.getValue());
        this.processEventInFlow(event, "outboundProperties");
        Assert.assertThat((Object)this.getFirstReceivedHeader("Host"), (Matcher)Matchers.is((Matcher)Matchers.not((Object)this.host.getValue())));
    }

    @Test
    public void acceptsTransferEncodingHeader() throws Exception {
        this.processEventInFlow(HttpRequestHeadersTestCase.getTestEvent((Object)"Test Message"), "transferEncodingHeader");
        Assert.assertThat((Object)this.getFirstReceivedHeader("Transfer-Encoding"), (Matcher)Matchers.is((Object)this.encoding.getValue()));
    }

    @Test
    public void ignoresTransferEncodingOutboundProperty() throws Exception {
        MuleEvent event = HttpRequestHeadersTestCase.getTestEvent((Object)"Test Message");
        event.getMessage().setOutboundProperty("Transfer-Encoding", (Object)this.encoding.getValue());
        this.processEventInFlow(event, "outboundProperties");
        Assert.assertThat((Object)this.headers.asMap(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"Transfer-Encoding")));
    }

    private void processEventInFlow(MuleEvent event, String flowName) throws Exception {
        Flow flow = (Flow)this.getFlowConstruct(flowName);
        flow.process(event);
    }
}

