/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.construct.Flow;
import org.mule.module.http.functional.requester.AbstractHttpRequestTestCase;

public class HttpRequestFormParamsTestCase
extends AbstractHttpRequestTestCase {
    private static final String URL_ENCODED_STRING = "testName1=testValue1&testName2=testValue2";

    protected String getConfigFile() {
        return "http-request-form-params-config.xml";
    }

    @Test
    public void sendsMapAsUrlEncodedBody() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("formParam");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("testName1", "testValue1");
        params.put("testName2", "testValue2");
        MuleEvent event = HttpRequestFormParamsTestCase.getTestEvent(params);
        flow.process(event);
        Assert.assertThat((Object)this.uri, (Matcher)CoreMatchers.equalTo((Object)"/testPath"));
        Assert.assertThat((Object)this.body, (Matcher)CoreMatchers.equalTo((Object)URL_ENCODED_STRING));
        Assert.assertThat((Object)this.getFirstReceivedHeader("Content-Type"), (Matcher)CoreMatchers.equalTo((Object)"application/x-www-form-urlencoded"));
    }

    @Test
    public void convertsUrlEncodedResponseToMap() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("formParam");
        MuleEvent event = flow.process(HttpRequestFormParamsTestCase.getTestEvent((Object)"Test Message"));
        Assert.assertThat((Object)event.getMessage().getPayload(), (Matcher)CoreMatchers.instanceOf(Map.class));
        Map payload = (Map)event.getMessage().getPayload();
        Assert.assertThat((Object)payload.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat(payload.get("testName1"), (Matcher)CoreMatchers.equalTo((Object)"testValue1"));
        Assert.assertThat(payload.get("testName2"), (Matcher)CoreMatchers.equalTo((Object)"testValue2"));
    }

    @Override
    protected void writeResponse(HttpServletResponse response) throws IOException {
        response.setContentType("application/x-www-form-urlencoded");
        response.setStatus(200);
        response.getWriter().print(URL_ENCODED_STRING);
    }
}

