/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.api.MuleEvent;
import org.mule.construct.Flow;
import org.mule.module.http.functional.requester.AbstractHttpRequestTestCase;

public class HttpRequestFollowRedirectsTestCase
extends AbstractHttpRequestTestCase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private static final String REDIRECTED = "Redirected.";
    private static final String MOVED = "Moved.";
    private static final String FLOW_VAR_KEY = "redirect";
    private static final String MOVED_URI = "/testPath";
    private static final String REDIRECT_URI = "/redirect";
    private static final String REDIRECT_WITH_PARAMS_URI = "/redirect?param1=value1&param2=value2";
    private MuleEvent testEvent;
    private boolean addParams = false;

    @Before
    public void setUp() throws Exception {
        this.testEvent = HttpRequestFollowRedirectsTestCase.getTestEvent((Object)"Test Message");
    }

    protected String getConfigFile() {
        return "http-request-follow-redirects-config.xml";
    }

    @Override
    protected boolean enableHttps() {
        return true;
    }

    @Override
    protected void handleRequest(Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.extractBaseRequestParts(baseRequest);
        if (baseRequest.getUri().getPath().startsWith(REDIRECT_URI)) {
            response.getWriter().print(REDIRECTED);
        } else {
            response.setHeader("Location", String.format("http://localhost:%s%s", this.httpPort.getNumber(), this.getRedirectUri()));
            response.setStatus(302);
            response.getWriter().print(MOVED);
        }
    }

    private String getRedirectUri() {
        return this.addParams ? REDIRECT_WITH_PARAMS_URI : REDIRECT_URI;
    }

    @Test
    public void followRedirectsByDefault() throws Exception {
        this.testRedirect("default", REDIRECTED, REDIRECT_URI);
    }

    @Test
    public void followRedirectsHttps() throws Exception {
        this.testRedirect("followRedirectsHttps", REDIRECTED, REDIRECT_URI);
    }

    @Test
    public void followRedirectsTrueInRequestElement() throws Exception {
        this.testRedirect("followRedirects", REDIRECTED, REDIRECT_URI);
    }

    @Test
    public void followRedirectsFalseInRequestElement() throws Exception {
        this.testRedirect("dontFollowRedirects", MOVED, MOVED_URI);
    }

    @Test
    public void followRedirectsWithBooleanExpression() throws Exception {
        this.testRedirectExpression("followRedirectsExpression", MOVED, MOVED_URI, false);
    }

    @Test
    public void followRedirectsWithStringExpression() throws Exception {
        this.testRedirectExpression("followRedirectsExpression", MOVED, MOVED_URI, "false");
    }

    @Test
    public void followRedirectsFalseInRequestConfigElement() throws Exception {
        this.testRedirect("fromConfig", MOVED, MOVED_URI);
    }

    @Test
    public void followRedirectsOverride() throws Exception {
        this.testRedirect("overrideConfig", REDIRECTED, REDIRECT_URI);
    }

    @Test
    public void followRedirectsExpressionInRequestConfigElement() throws Exception {
        this.testRedirectExpression("fromConfigExpression", REDIRECTED, REDIRECT_URI, true);
    }

    @Test
    public void followRedirectsWithParamsByDefault() throws Exception {
        this.addParams = true;
        this.testRedirect("default", REDIRECTED, REDIRECT_WITH_PARAMS_URI);
    }

    @Test
    public void followRedirectsWithParamsHttps() throws Exception {
        this.addParams = true;
        this.testRedirect("followRedirectsHttps", REDIRECTED, REDIRECT_WITH_PARAMS_URI);
    }

    private void testRedirectExpression(String flowName, String expectedPayload, String expectedPath, Object flowVar) throws Exception {
        this.testEvent.setFlowVariable(FLOW_VAR_KEY, flowVar);
        this.testRedirect(flowName, expectedPayload, expectedPath);
    }

    private void testRedirect(String flowName, String expectedPayload, String expectedPath) throws Exception {
        Flow flow = (Flow)this.getFlowConstruct(flowName);
        MuleEvent result = flow.process(this.testEvent);
        Assert.assertThat((Object)result.getMessage().getPayloadAsString(), (Matcher)Matchers.is((Object)expectedPayload));
        Assert.assertThat((Object)this.uri, (Matcher)Matchers.is((Object)expectedPath));
    }
}

