/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import java.io.IOException;
import java.io.InputStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mule.api.MuleEvent;
import org.mule.construct.Flow;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.functional.AbstractHttpExpectHeaderServerTestCase;
import org.mule.tck.junit4.FlakinessDetectorTestRunner;
import org.mule.tck.junit4.FlakyTest;

@RunWith(value=FlakinessDetectorTestRunner.class)
public class HttpRequestExpectHeaderTestCase
extends AbstractHttpExpectHeaderServerTestCase {
    private static final String REQUEST_FLOW_NAME = "requestFlow";

    protected String getConfigFile() {
        return "http-request-expect-header-config.xml";
    }

    @FlakyTest
    @Test
    public void handlesContinueResponse() throws Exception {
        this.startExpectContinueServer();
        Flow flow = (Flow)this.getFlowConstruct(REQUEST_FLOW_NAME);
        MuleEvent event = HttpRequestExpectHeaderTestCase.getTestEvent((Object)"Test Message");
        event.getMessage().setOutboundProperty("Expect", (Object)"100-continue");
        flow.process(event);
        Assert.assertThat((Object)this.requestBody, (Matcher)CoreMatchers.equalTo((Object)"Test Message"));
        this.stopServer();
    }

    @Test
    public void handlesExpectationFailedResponse() throws Exception {
        this.startExpectFailedServer();
        Flow flow = (Flow)this.getFlowConstruct(REQUEST_FLOW_NAME);
        MuleEvent event = HttpRequestExpectHeaderTestCase.getTestEvent((Object)new InputStream(){

            @Override
            public int read() throws IOException {
                throw new IOException("Payload should not be consumed");
            }
        });
        event.getMessage().setOutboundProperty("Expect", (Object)"100-continue");
        MuleEvent response = flow.process(event);
        Assert.assertThat((Object)response.getMessage().getInboundProperty("http.status"), (Matcher)CoreMatchers.equalTo((Object)HttpConstants.HttpStatus.EXPECTATION_FAILED.getStatusCode()));
        this.stopServer();
    }
}

