/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.module.http.functional.requester.AbstractHttpRequestTestCase;

public class HttpRequestCookiesTestCase
extends AbstractHttpRequestTestCase {
    private static final String COOKIE_ROOT_PATH_LOCAL_DOMAIN = "cookieRootPathLocalDomain";
    private static final String COOKIE_CUSTOM_PATH_LOCAL_DOMAIN = "cookieCustomPathLocalDomain";
    private static final String COOKIE_ROOT_PATH_CUSTOM_DOMAIN = "cookieRootPathCustomDomain";
    private static final String COOKIE_EXPIRED = "cookieExpired";
    private static final String COOKIE_TEST_VALUE = "test";
    private static final String CLIENT_COOKIES_ENABLED_FLOW = "clientCookiesEnabled";
    private static final String CLIENT_COOKIES_DISABLED_FLOW = "clientCookiesDisabled";

    protected String getConfigFile() {
        return "http-request-cookies-config.xml";
    }

    @Test
    public void cookiesEnabledForSameDomainAndPath() throws Exception {
        MuleEvent event = HttpRequestCookiesTestCase.getTestEvent((Object)"Test Message");
        event.setFlowVariable("path", (Object)"/");
        this.runFlow(CLIENT_COOKIES_ENABLED_FLOW, event);
        this.assertNoCookiesSent();
        this.runFlow(CLIENT_COOKIES_ENABLED_FLOW, event);
        this.assertCookiesSent(COOKIE_ROOT_PATH_LOCAL_DOMAIN);
    }

    @Test
    public void cookiesEnabledForSpecificPath() throws Exception {
        MuleEvent event = HttpRequestCookiesTestCase.getTestEvent((Object)"Test Message");
        event.setFlowVariable("path", (Object)"/path");
        this.runFlow(CLIENT_COOKIES_ENABLED_FLOW, event);
        this.assertNoCookiesSent();
        this.runFlow(CLIENT_COOKIES_ENABLED_FLOW, event);
        this.assertCookiesSent(COOKIE_ROOT_PATH_LOCAL_DOMAIN, COOKIE_CUSTOM_PATH_LOCAL_DOMAIN);
    }

    @Test
    public void cookiesDisabledKeepsNoStateBetweenRequests() throws Exception {
        MuleEvent event = HttpRequestCookiesTestCase.getTestEvent((Object)"Test Message");
        this.runFlow(CLIENT_COOKIES_DISABLED_FLOW, event);
        this.assertNoCookiesSent();
        this.runFlow(CLIENT_COOKIES_DISABLED_FLOW, event);
        this.assertNoCookiesSent();
    }

    private void assertCookiesSent(String ... cookies) {
        Assert.assertThat((Object)this.headers.containsKey((Object)"Cookie"), (Matcher)CoreMatchers.is((Object)true));
        HashSet sentCookies = new HashSet(this.headers.get((Object)"Cookie"));
        HashSet expectedCookies = Sets.newHashSet();
        for (String cookie : cookies) {
            expectedCookies.add(cookie + "=" + COOKIE_TEST_VALUE);
        }
        Assert.assertThat(sentCookies, (Matcher)CoreMatchers.equalTo((Object)expectedCookies));
    }

    private void assertNoCookiesSent() {
        Assert.assertThat((Object)this.headers.containsKey((Object)"Cookie"), (Matcher)CoreMatchers.is((Object)false));
    }

    @Override
    protected void writeResponse(HttpServletResponse response) throws IOException {
        Cookie cookie = new Cookie(COOKIE_ROOT_PATH_LOCAL_DOMAIN, COOKIE_TEST_VALUE);
        cookie.setPath("/");
        cookie.setDomain(".local");
        response.addCookie(cookie);
        cookie = new Cookie(COOKIE_CUSTOM_PATH_LOCAL_DOMAIN, COOKIE_TEST_VALUE);
        cookie.setPath("/path");
        cookie.setDomain(".local");
        response.addCookie(cookie);
        cookie = new Cookie(COOKIE_ROOT_PATH_CUSTOM_DOMAIN, COOKIE_TEST_VALUE);
        cookie.setPath("/");
        cookie.setDomain("domain");
        response.addCookie(cookie);
        cookie = new Cookie(COOKIE_EXPIRED, COOKIE_TEST_VALUE);
        cookie.setPath("/");
        cookie.setDomain(".local");
        cookie.setMaxAge(0);
        response.addCookie(cookie);
        super.writeResponse(response);
    }
}

