/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

public class HttpRequestContentTypeTestCase
extends FunctionalTestCase {
    private static final String EXPECTED_CONTENT_TYPE = "application/json; charset=UTF-8";
    @Rule
    public DynamicPort httpPort = new DynamicPort("httpPort");
    @Rule
    public SystemProperty strictContentType = new SystemProperty("mule.strictContentType", Boolean.TRUE.toString());

    protected String getConfigFile() {
        return "http-request-content-type-config.xml";
    }

    @Test
    public void sendsContentTypeOnRequest() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        String url = String.format("http://localhost:%s/requestClient", this.httpPort.getNumber());
        MuleMessage response = client.send(url, (Object)"Test Message", null);
        this.assertContentTypeProperty(response);
        MatcherAssert.assertThat((Object)response.getPayloadAsString(), (Matcher)Matchers.equalTo((Object)EXPECTED_CONTENT_TYPE));
    }

    private void assertContentTypeProperty(MuleMessage response) {
        MatcherAssert.assertThat((Object)response.getInboundPropertyNames(), (Matcher)Matchers.hasItem((Matcher)Matchers.equalToIgnoringCase((String)"Content-Type")));
        MatcherAssert.assertThat((Object)((String)response.getInboundProperty("Content-Type")), (Matcher)Matchers.equalTo((Object)EXPECTED_CONTENT_TYPE));
    }
}

