/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import java.io.IOException;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Request;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.construct.Flow;
import org.mule.module.http.functional.requester.AbstractHttpRequestTestCase;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

public class HttpRequestConnectionsPersistenceTestCase
extends AbstractHttpRequestTestCase {
    private static final int GRIZZLY_IDLE_CHECK_TIMEOUT_MILLIS = 6000;
    private static final int POLL_DELAY_MILLIS = 200;
    private int remotePort;

    protected String getConfigFile() {
        return "http-request-connections-persistence-config.xml";
    }

    @Test
    public void persistentConnections() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("persistent");
        flow.process(HttpRequestConnectionsPersistenceTestCase.getTestEvent((Object)"Test Message"));
        this.ensureConnectionIsOpen();
        new PollingProber(6000L, 200L).check((Probe)new JUnitProbe(){

            public boolean test() throws Exception {
                return HttpRequestConnectionsPersistenceTestCase.this.isConnectionClosed();
            }

            public String describeFailure() {
                return "Connection should be closed.";
            }
        });
    }

    @Test
    public void nonPersistentConnections() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("nonPersistent");
        flow.process(HttpRequestConnectionsPersistenceTestCase.getTestEvent((Object)"Test Message"));
        Assert.assertThat((Object)this.isConnectionClosed(), (Matcher)Matchers.is((Object)true));
    }

    private void ensureConnectionIsOpen() {
        EndPoint endPoint = this.getConnectedEndPoint();
        Assert.assertThat((Object)endPoint, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)endPoint.getLocalAddress().getPort(), (Matcher)Matchers.is((Object)this.httpPort.getNumber()));
        Assert.assertThat((Object)endPoint.getRemoteAddress().getPort(), (Matcher)Matchers.is((Object)this.remotePort));
    }

    private boolean isConnectionClosed() {
        return this.getConnectedEndPoint() == null;
    }

    private EndPoint getConnectedEndPoint() {
        Assert.assertThat((Object)this.server.getConnectors().length, (Matcher)Matchers.is((Object)1));
        Collection connectedEndpoints = this.server.getConnectors()[0].getConnectedEndPoints();
        if (!connectedEndpoints.isEmpty()) {
            return (EndPoint)connectedEndpoints.iterator().next();
        }
        return null;
    }

    @Override
    protected void handleRequest(Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        super.handleRequest(baseRequest, request, response);
        this.remotePort = request.getRemotePort();
    }
}

