/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import org.junit.Before;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.MuleRegistry;
import org.mule.module.http.internal.request.DefaultHttpRequesterConfig;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class HttpRequestConnectionsConfigurationTestCase
extends AbstractMuleTestCase {
    private MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());

    @Before
    public void before() {
        MuleRegistry registry = (MuleRegistry)Mockito.mock(MuleRegistry.class);
        Mockito.when((Object)registry.get("_httpClientFactory")).thenReturn(null);
        Mockito.when((Object)this.mockMuleContext.getRegistry()).thenReturn((Object)registry);
    }

    @Test(expected=InitialisationException.class)
    public void invalidMaxConnections() throws InitialisationException {
        DefaultHttpRequesterConfig httpRequesterConfig = this.createRequesterConfig();
        httpRequesterConfig.setMaxConnections(-2);
        httpRequesterConfig.initialise();
    }

    @Test(expected=InitialisationException.class)
    public void invalidMaxConnections0() throws InitialisationException {
        DefaultHttpRequesterConfig httpRequesterConfig = this.createRequesterConfig();
        httpRequesterConfig.setMaxConnections(0);
        httpRequesterConfig.initialise();
    }

    @Test
    public void ignoreIdleTimeoutIfNotPersistentConnections() throws MuleException {
        DefaultHttpRequesterConfig httpRequesterConfig = this.createRequesterConfig();
        httpRequesterConfig.setUsePersistentConnections(false);
        httpRequesterConfig.setConnectionIdleTimeout(-2);
        httpRequesterConfig.initialise();
        httpRequesterConfig.stop();
    }

    private DefaultHttpRequesterConfig createRequesterConfig() {
        DefaultHttpRequesterConfig requesterConfig = new DefaultHttpRequesterConfig();
        requesterConfig.setMuleContext(this.mockMuleContext);
        requesterConfig.setName("TestConfig");
        return requesterConfig;
    }
}

