/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import com.ning.http.client.ntlm.NTLMEngine;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.module.http.functional.requester.AbstractHttpRequestTestCase;
import org.mule.util.NetworkUtils;

public abstract class AbstractNtlmTestCase
extends AbstractHttpRequestTestCase {
    private static final String TYPE_1_MESSAGE = "NTLM TlRMTVNTUAABAAAAAYIIogAAAAAoAAAAAAAAACgAAAAFASgKAAAADw==";
    private static final String TYPE_2_MESSAGE_CHALLENGE = "TlRMTVNTUAACAAAAAAAAACgAAAABggAAU3J2Tm9uY2UAAAAAAAAAAA==";
    private static final String TYPE_2_MESSAGE = "NTLM TlRMTVNTUAACAAAAAAAAACgAAAABggAAU3J2Tm9uY2UAAAAAAAAAAA==";
    private static final String USER = "Zaphod";
    private static final String PASSWORD = "Beeblebrox";
    private static final String DOMAIN = "Ursa-Minor";
    private static final String AUTHORIZED = "Authorized";
    private String type3Message;
    protected String requestUrl;
    private String clientAuthHeader;
    private String serverAuthHeader;
    private int unauthorizedHeader;

    public AbstractNtlmTestCase(String clientAuthHeader, String serverAuthHeader, int unauthorizedHeader) {
        this.clientAuthHeader = clientAuthHeader;
        this.serverAuthHeader = serverAuthHeader;
        this.unauthorizedHeader = unauthorizedHeader;
    }

    @Before
    public void setUp() throws Exception {
        String workstation = this.getWorkstation();
        String ntlmHost = workstation != null ? workstation : NetworkUtils.getLocalHost().getHostName();
        String type3Challenge = NTLMEngine.INSTANCE.generateType3Msg(USER, PASSWORD, this.getDomain(), ntlmHost, TYPE_2_MESSAGE_CHALLENGE);
        this.type3Message = "NTLM " + type3Challenge;
    }

    protected String getDomain() {
        return DOMAIN;
    }

    protected String getWorkstation() {
        return null;
    }

    @Override
    protected void handleRequest(Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String auth = request.getHeader(this.clientAuthHeader);
        if (auth == null) {
            response.setStatus(this.unauthorizedHeader);
            response.addHeader(this.serverAuthHeader, "NTLM");
        }
        if (TYPE_1_MESSAGE.equals(auth)) {
            response.setStatus(this.unauthorizedHeader);
            response.setHeader(this.serverAuthHeader, TYPE_2_MESSAGE);
        } else if (this.type3Message.equals(auth)) {
            this.requestUrl = baseRequest.getRequestURL().toString();
            response.setStatus(200);
            response.getWriter().print(AUTHORIZED);
        } else {
            response.setStatus(401);
        }
    }

    @Test
    public void validNtlmAuth() throws Exception {
        MuleEvent event = this.runFlow(this.getFlowName());
        Assert.assertThat((Object)((Integer)event.getMessage().getInboundProperty("http.status")), (Matcher)Matchers.is((Object)200));
        Assert.assertThat((Object)event.getMessage().getPayloadAsString(), (Matcher)CoreMatchers.equalTo((Object)AUTHORIZED));
    }

    protected String getFlowName() {
        return "ntlmFlow";
    }
}

