/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import com.google.common.base.Supplier;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.EnumerationUtils;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.CaseInsensitiveMapWrapper;
import org.mule.util.FileUtils;
import org.mule.util.IOUtils;

public class AbstractHttpRequestTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort httpPort = new DynamicPort("httpPort");
    @Rule
    public DynamicPort httpsPort = new DynamicPort("httpsPort");
    public static final String DEFAULT_RESPONSE = "<h1>Response</h1>";
    protected Server server;
    protected String method;
    protected String uri;
    protected Multimap<String, String> headers = Multimaps.newMultimap((Map)new CaseInsensitiveMapWrapper(HashMap.class, new Object[0]), (Supplier)new Supplier<Collection<String>>(){

        public Collection<String> get() {
            return Sets.newHashSet();
        }
    });
    protected String body;

    @Before
    public void startServer() throws Exception {
        this.server = this.createServer();
        this.server.setHandler((Handler)this.createHandler(this.server));
        this.server.start();
    }

    @After
    public void stopServer() throws Exception {
        this.server.stop();
    }

    protected Server createServer() {
        Server server = new Server(this.httpPort.getNumber());
        if (this.enableHttps()) {
            this.enableHttpsServer(server);
        }
        return server;
    }

    protected boolean enableHttps() {
        return false;
    }

    private void enableHttpsServer(Server server) {
        SslContextFactory sslContextFactory = new SslContextFactory();
        try {
            sslContextFactory.setKeyStorePath(FileUtils.getResourcePath((String)"tls/serverKeystore", ((Object)((Object)this)).getClass()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        sslContextFactory.setKeyStorePassword("mulepassword");
        sslContextFactory.setKeyManagerPassword("mulepassword");
        ServerConnector connector = new ServerConnector(server, sslContextFactory);
        connector.setPort(this.httpsPort.getNumber());
        server.addConnector((Connector)connector);
    }

    protected AbstractHandler createHandler(Server server) {
        return new TestHandler();
    }

    protected void handleRequest(Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.extractBaseRequestParts(baseRequest);
        this.writeResponse(response);
    }

    protected void extractBaseRequestParts(Request baseRequest) throws IOException {
        this.method = baseRequest.getMethod();
        this.uri = baseRequest.getUri().getCompletePath();
        this.extractHeadersFromBaseRequest(baseRequest);
        this.body = IOUtils.toString((InputStream)baseRequest.getInputStream());
    }

    protected void extractHeadersFromBaseRequest(Request baseRequest) {
        for (String headerName : EnumerationUtils.toList((Enumeration)baseRequest.getHeaderNames())) {
            Enumeration headerValues = baseRequest.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                this.headers.put((Object)headerName, headerValues.nextElement());
            }
        }
    }

    protected void writeResponse(HttpServletResponse response) throws IOException {
        response.setContentType("text/html");
        response.setStatus(200);
        response.getWriter().print(DEFAULT_RESPONSE);
    }

    public String getFirstReceivedHeader(String headerName) {
        return (String)this.headers.get((Object)headerName).iterator().next();
    }

    private class TestHandler
    extends AbstractHandler {
        private TestHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            AbstractHttpRequestTestCase.this.handleRequest(baseRequest, request, response);
            baseRequest.setHandled(true);
        }
    }
}

