/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.listener;

import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MessagingException;
import org.mule.api.MuleMessage;
import org.mule.api.client.OperationOptions;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.functional.FlowAssert;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.ssl.DefaultTlsContextFactory;
import org.mule.transport.ssl.api.TlsContextFactory;

public class HttpListenerValidateCertificateTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort portWithValidation = new DynamicPort("port1");
    @Rule
    public DynamicPort portWithoutValidation = new DynamicPort("port2");
    private DefaultTlsContextFactory tlsContextFactory;

    protected String getConfigFile() {
        return "http-listener-validate-certificate-config.xml";
    }

    @Before
    public void setup() throws IOException {
        this.tlsContextFactory = new DefaultTlsContextFactory();
        this.tlsContextFactory.setTrustStorePath("tls/trustStore");
        this.tlsContextFactory.setTrustStorePassword("mulepassword");
    }

    @Test(expected=MessagingException.class)
    public void serverWithValidationRejectsRequestWithInvalidCertificate() throws Exception {
        this.sendRequest(this.getUrl(this.portWithValidation.getNumber()), "Test Message");
    }

    @Test
    public void serverWithValidationAcceptsRequestWithValidCertificate() throws Exception {
        this.configureClientKeyStore();
        this.assertValidRequest(this.getUrl(this.portWithValidation.getNumber()));
        FlowAssert.verify((String)"listenerWithTrustStoreFlow");
    }

    @Test
    public void serverWithoutValidationAcceptsRequestWithInvalidCertificate() throws Exception {
        this.assertValidRequest(this.getUrl(this.portWithoutValidation.getNumber()));
    }

    @Test
    public void serverWithoutValidationAcceptsRequestWithValidCertificate() throws Exception {
        this.configureClientKeyStore();
        this.assertValidRequest(this.getUrl(this.portWithoutValidation.getNumber()));
    }

    private String sendRequest(String url, String payload) throws Exception {
        MuleMessage response = muleContext.getClient().send(url, this.getTestMuleMessage(payload), (OperationOptions)HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).tlsContextFactory((TlsContextFactory)this.tlsContextFactory).build());
        return response.getPayloadAsString();
    }

    private void assertValidRequest(String url) throws Exception {
        Assert.assertThat((Object)this.sendRequest(url, "Test Message"), (Matcher)CoreMatchers.equalTo((Object)"Test Message"));
    }

    private void configureClientKeyStore() throws IOException {
        this.tlsContextFactory.setKeyStorePath("tls/ssltest-keystore.jks");
        this.tlsContextFactory.setKeyStorePassword("changeit");
        this.tlsContextFactory.setKeyManagerPassword("changeit");
    }

    private String getUrl(int port) {
        return String.format("https://localhost:%d/", port);
    }
}

