/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.listener;

import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.rules.ExpectedException;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.construct.Flow;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpListenerTlsInsecureTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort port1 = new DynamicPort("port1");
    @Rule
    public DynamicPort port2 = new DynamicPort("port2");
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    protected String getConfigFile() {
        return "http-listener-insecure-config.xml";
    }

    @Test
    public void acceptsInvalidCertificateIfInsecure() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("testRequestToInsecure");
        MuleEvent res = flow.process(HttpListenerTlsInsecureTestCase.getTestEvent((Object)"test"));
        Assert.assertThat((Object)res.getMessage().getPayloadAsString(), (Matcher)Is.is((Object)"test"));
    }

    @Test
    public void rejectsInvalidCertificateIfSecure() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("testRequestToSecure");
        this.expectedException.expect(MessagingException.class);
        this.expectedException.expectCause(Matchers.isA(IOException.class));
        this.expectedException.expectCause(ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)"Remotely close")));
        flow.process(HttpListenerTlsInsecureTestCase.getTestEvent((Object)"data"));
    }
}

