/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.listener;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Rule;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.IOUtils;

public abstract class HttpListenerResponseStreamingTestCase
extends FunctionalTestCase {
    private static final int DEFAULT_TIMEOUT = 1000;
    public static final String TEST_BODY = RandomStringUtils.randomAlphabetic((int)102400);
    @Rule
    public DynamicPort listenPort = new DynamicPort("port");

    protected abstract HttpVersion getHttpVersion();

    protected String getConfigFile() {
        return "http-listener-response-streaming-config.xml";
    }

    protected void testResponseIsContentLengthEncoding(String url, HttpVersion httpVersion) throws IOException {
        Response response = Request.Get((String)url).version(httpVersion).connectTimeout(1000).socketTimeout(1000).execute();
        HttpResponse httpResponse = response.returnResponse();
        Header transferEncodingHeader = httpResponse.getFirstHeader("Transfer-Encoding");
        Header contentLengthHeader = httpResponse.getFirstHeader("Content-Length");
        Assert.assertThat((Object)contentLengthHeader, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)transferEncodingHeader, (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)IOUtils.toString((InputStream)httpResponse.getEntity().getContent()), (Matcher)CoreMatchers.is((Object)TEST_BODY));
    }

    protected String getUrl(String path) {
        return String.format("http://localhost:%s/%s", this.listenPort.getNumber(), path);
    }

    protected void testResponseIsChunkedEncoding(String url, HttpVersion httpVersion) throws IOException {
        Response response = Request.Post((String)url).version(httpVersion).connectTimeout(1000).socketTimeout(1000).bodyByteArray(TEST_BODY.getBytes()).execute();
        HttpResponse httpResponse = response.returnResponse();
        Header transferEncodingHeader = httpResponse.getFirstHeader("Transfer-Encoding");
        Header contentLengthHeader = httpResponse.getFirstHeader("Content-Length");
        Assert.assertThat((Object)contentLengthHeader, (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)transferEncodingHeader, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)transferEncodingHeader.getValue(), (Matcher)CoreMatchers.is((Object)"chunked"));
        Assert.assertThat((Object)IOUtils.toString((InputStream)httpResponse.getEntity().getContent()), (Matcher)CoreMatchers.is((Object)TEST_BODY));
    }

    protected void testResponseIsNotChunkedEncoding(String url, HttpVersion httpVersion) throws IOException {
        Response response = Request.Post((String)url).version(httpVersion).connectTimeout(1000).socketTimeout(1000).bodyByteArray(TEST_BODY.getBytes()).execute();
        HttpResponse httpResponse = response.returnResponse();
        Header transferEncodingHeader = httpResponse.getFirstHeader("Transfer-Encoding");
        Header contentLengthHeader = httpResponse.getFirstHeader("Content-Length");
        Assert.assertThat((Object)contentLengthHeader, (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)transferEncodingHeader, (Matcher)CoreMatchers.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)IOUtils.toString((InputStream)httpResponse.getEntity().getContent()), (Matcher)CoreMatchers.is((Object)TEST_BODY));
    }
}

