/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.listener;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.IOUtils;

public class HttpListenerResponseStreamingExceptionStrategyTestCase
extends FunctionalTestCase {
    private static final int DEFAULT_TIMEOUT = 1000;
    public static InputStream stream;
    @Rule
    public DynamicPort listenPort = new DynamicPort("port");

    protected String getConfigFile() {
        return "http-listener-response-streaming-exception-strategy-config.xml";
    }

    @BeforeClass
    public static void beforeClass() throws IOException {
        stream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)stream.read()).thenThrow(new Throwable[]{new RuntimeException("Some exception")});
        Mockito.when((Object)stream.read((byte[])Matchers.any(byte[].class))).thenThrow(new Throwable[]{new RuntimeException("Some exception")});
        Mockito.when((Object)stream.read((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt())).thenThrow(new Throwable[]{new RuntimeException("Some exception")});
    }

    @Before
    public void before() {
        TrackPassageMessageProcessor.passed = false;
    }

    protected String getUrl(String path) {
        return String.format("http://localhost:%s/%s", this.listenPort.getNumber(), path);
    }

    @Test
    public void exceptionHandledWhenBuildingResponse() throws Exception {
        Response response = Request.Get((String)this.getUrl("exceptionBuildingResponse")).connectTimeout(1000).socketTimeout(1000).execute();
        HttpResponse httpResponse = response.returnResponse();
        this.assertExceptionStrategyExecuted(httpResponse);
    }

    @Test
    public void exceptionNotHandledWhenSendingResponse() throws Exception {
        Response response = Request.Get((String)this.getUrl("exceptionSendingResponse")).connectTimeout(1000).socketTimeout(1000).execute();
        HttpResponse httpResponse = response.returnResponse();
        this.assertExceptionStrategyNotExecuted(httpResponse);
    }

    @Test
    public void exceptionHandledWhenBuildingResponseFailAgain() throws Exception {
        Response response = Request.Get((String)this.getUrl("exceptionBuildingResponseFailAgain")).connectTimeout(1000).socketTimeout(1000).execute();
        HttpResponse httpResponse = response.returnResponse();
        this.assertExceptionStrategyFailed(httpResponse);
    }

    @Test
    public void exceptionNotHandledWhenSendingResponseFailAgain() throws Exception {
        Response response = Request.Get((String)this.getUrl("exceptionSendingResponseFailAgain")).connectTimeout(1000).socketTimeout(1000).execute();
        HttpResponse httpResponse = response.returnResponse();
        this.assertExceptionStrategyNotExecuted(httpResponse);
    }

    protected void assertExceptionStrategyExecuted(HttpResponse httpResponse) throws IOException {
        Assert.assertThat((Object)httpResponse.getStatusLine().getStatusCode(), (Matcher)CoreMatchers.is((Object)200));
        Assert.assertThat((Object)IOUtils.toString((InputStream)httpResponse.getEntity().getContent()), (Matcher)CoreMatchers.is((Object)"Exception Handled"));
        Assert.assertThat((Object)TrackPassageMessageProcessor.passed, (Matcher)CoreMatchers.is((Object)true));
    }

    protected void assertExceptionStrategyFailed(HttpResponse httpResponse) throws IOException {
        Assert.assertThat((Object)httpResponse.getStatusLine().getStatusCode(), (Matcher)CoreMatchers.is((Object)500));
        Assert.assertThat((Object)IOUtils.toString((InputStream)httpResponse.getEntity().getContent()), (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)TrackPassageMessageProcessor.passed, (Matcher)CoreMatchers.is((Object)true));
    }

    protected void assertExceptionStrategyNotExecuted(HttpResponse httpResponse) throws IOException {
        Assert.assertThat((Object)httpResponse.getStatusLine().getStatusCode(), (Matcher)CoreMatchers.is((Object)500));
        Assert.assertThat((Object)IOUtils.toString((InputStream)httpResponse.getEntity().getContent()), (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)TrackPassageMessageProcessor.passed, (Matcher)CoreMatchers.is((Object)false));
    }

    public static class TrackPassageMessageProcessor
    implements MessageProcessor {
        public static boolean passed = false;

        public MuleEvent process(MuleEvent event) throws MuleException {
            passed = true;
            return event;
        }
    }
}

