/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.listener;

import org.apache.http.HttpVersion;
import org.junit.Test;
import org.mule.module.http.functional.listener.HttpListenerResponseStreamingTestCase;

public class HttpListenerResponseStreaming11TestCase
extends HttpListenerResponseStreamingTestCase {
    @Override
    protected HttpVersion getHttpVersion() {
        return HttpVersion.HTTP_1_1;
    }

    @Test
    public void string() throws Exception {
        String url = this.getUrl("string");
        this.testResponseIsContentLengthEncoding(url, this.getHttpVersion());
    }

    @Test
    public void stringWithContentLengthHeader() throws Exception {
        String url = this.getUrl("stringWithContentLengthHeader");
        this.testResponseIsContentLengthEncoding(url, this.getHttpVersion());
    }

    @Test
    public void stringWithContentLengthOutboundProperty() throws Exception {
        String url = this.getUrl("stringWithContentLengthOutboundProperty");
        this.testResponseIsContentLengthEncoding(url, this.getHttpVersion());
    }

    @Test
    public void stringWithTransferEncodingHeader() throws Exception {
        String url = this.getUrl("stringWithTransferEncodingHeader");
        this.testResponseIsChunkedEncoding(url, this.getHttpVersion());
    }

    @Test
    public void stringWithTransferEncodingOutboundProperty() throws Exception {
        String url = this.getUrl("stringWithTransferEncodingOutboundProperty");
        this.testResponseIsContentLengthEncoding(url, this.getHttpVersion());
    }

    @Test
    public void stringWithTransferEncodingAndContentLengthHeader() throws Exception {
        String url = this.getUrl("stringWithTransferEncodingAndContentLengthHeader");
        this.testResponseIsContentLengthEncoding(url, this.getHttpVersion());
    }

    @Test
    public void stringWithTransferEncodingAndContentLengthOutboundProperty() throws Exception {
        String url = this.getUrl("stringWithTransferEncodingAndContentLengthOutboundProperty");
        this.testResponseIsContentLengthEncoding(url, this.getHttpVersion());
    }

    @Test
    public void stringWithTransferEncodingHeaderAndContentLengthOutboundProperty() throws Exception {
        String url = this.getUrl("stringWithTransferEncodingHeaderAndContentLengthOutboundProperty");
        this.testResponseIsContentLengthEncoding(url, this.getHttpVersion());
    }

    @Test
    public void stringWithTransferEncodingOutboundPropertyAndContentLengthHeader() throws Exception {
        String url = this.getUrl("stringWithTransferEncodingOutboundPropertyAndContentLengthHeader");
        this.testResponseIsContentLengthEncoding(url, this.getHttpVersion());
    }

    @Test
    public void inputStream() throws Exception {
        String url = this.getUrl("inputStream");
        this.testResponseIsChunkedEncoding(url, this.getHttpVersion());
    }

    @Test
    public void inputStreamWithContentLengthHeader() throws Exception {
        String url = this.getUrl("inputStreamWithContentLengthHeader");
        this.testResponseIsContentLengthEncoding(url, this.getHttpVersion());
    }

    @Test
    public void inputStreamWithContentLengthOutboundProperty() throws Exception {
        String url = this.getUrl("inputStreamWithContentLengthOutboundProperty");
        this.testResponseIsContentLengthEncoding(url, this.getHttpVersion());
    }

    @Test
    public void inputStreamWithTransferEncodingHeader() throws Exception {
        String url = this.getUrl("inputStreamWithTransferEncodingHeader");
        this.testResponseIsChunkedEncoding(url, this.getHttpVersion());
    }

    @Test
    public void inputStreamWithTransferEncodingOutboundProperty() throws Exception {
        String url = this.getUrl("inputStreamWithTransferEncodingOutboundProperty");
        this.testResponseIsChunkedEncoding(url, this.getHttpVersion());
    }

    @Test
    public void inputStreamWithTransferEncodingAndContentLengthHeader() throws Exception {
        String url = this.getUrl("inputStreamWithTransferEncodingAndContentLengthHeader");
        this.testResponseIsContentLengthEncoding(url, this.getHttpVersion());
    }

    @Test
    public void inputStreamWithTransferEncodingAndContentLengthOutboundProperty() throws Exception {
        String url = this.getUrl("inputStreamWithTransferEncodingAndContentLengthOutboundProperty");
        this.testResponseIsContentLengthEncoding(url, this.getHttpVersion());
    }

    @Test
    public void inputStreamWithTransferEncodingHeaderAndContentLengthOutboundProperty() throws Exception {
        String url = this.getUrl("inputStreamWithTransferEncodingHeaderAndContentLengthOutboundProperty");
        this.testResponseIsContentLengthEncoding(url, this.getHttpVersion());
    }

    @Test
    public void inputStreamWithTransferEncodingOutboundPropertyAndContentLengthHeader() throws Exception {
        String url = this.getUrl("inputStreamWithTransferEncodingOutboundPropertyAndContentLengthHeader");
        this.testResponseIsContentLengthEncoding(url, this.getHttpVersion());
    }

    @Test
    public void neverString() throws Exception {
        String url = this.getUrl("neverString");
        this.testResponseIsContentLengthEncoding(url, this.getHttpVersion());
    }

    @Test
    public void neverStringTransferEncodingHeader() throws Exception {
        String url = this.getUrl("neverStringTransferEncodingHeader");
        this.testResponseIsContentLengthEncoding(url, this.getHttpVersion());
    }

    @Test
    public void neverStringTransferEncodingOutboundProperty() throws Exception {
        String url = this.getUrl("neverStringTransferEncodingOutboundProperty");
        this.testResponseIsContentLengthEncoding(url, this.getHttpVersion());
    }

    @Test
    public void neverInputStream() throws Exception {
        String url = this.getUrl("neverInputStream");
        this.testResponseIsContentLengthEncoding(url, this.getHttpVersion());
    }

    @Test
    public void neverInputStreamTransferEncodingHeader() throws Exception {
        String url = this.getUrl("neverInputStreamTransferEncodingHeader");
        this.testResponseIsContentLengthEncoding(url, this.getHttpVersion());
    }

    @Test
    public void neverInputStreamTransferEncodingOutboundProperty() throws Exception {
        String url = this.getUrl("neverInputStreamTransferEncodingOutboundProperty");
        this.testResponseIsContentLengthEncoding(url, this.getHttpVersion());
    }

    @Test
    public void alwaysString() throws Exception {
        String url = this.getUrl("alwaysString");
        this.testResponseIsChunkedEncoding(url, this.getHttpVersion());
    }

    @Test
    public void alwaysStringContentLengthHeader() throws Exception {
        String url = this.getUrl("alwaysStringContentLengthHeader");
        this.testResponseIsChunkedEncoding(url, this.getHttpVersion());
    }

    @Test
    public void alwaysStringContentLengthOutboundProperty() throws Exception {
        String url = this.getUrl("alwaysStringContentLengthOutboundProperty");
        this.testResponseIsChunkedEncoding(url, this.getHttpVersion());
    }

    @Test
    public void alwaysInputStream() throws Exception {
        String url = this.getUrl("alwaysInputStream");
        this.testResponseIsChunkedEncoding(url, this.getHttpVersion());
    }

    @Test
    public void alwaysInputStreamContentLengthHeader() throws Exception {
        String url = this.getUrl("alwaysInputStreamContentLengthHeader");
        this.testResponseIsChunkedEncoding(url, this.getHttpVersion());
    }

    @Test
    public void alwaysInputStreamContentLengthOutboundProperty() throws Exception {
        String url = this.getUrl("alwaysInputStreamContentLengthOutboundProperty");
        this.testResponseIsChunkedEncoding(url, this.getHttpVersion());
    }
}

