/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.listener;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

public class HttpListenerResponseBuilderTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort listenPort = new DynamicPort("port");
    @Rule
    public SystemProperty emptyResponseBuilderPath = new SystemProperty("emptyResponseBuilderPath", "emptyResponseBuilderPath");
    @Rule
    public SystemProperty statusResponseBuilderPath = new SystemProperty("statusResponseBuilderPath", "statusResponseBuilderPath");
    @Rule
    public SystemProperty statusResponseBuilderOverridePath = new SystemProperty("statusResponseBuilderOverridePath", "statusResponseBuilderOverridePath");
    @Rule
    public SystemProperty reasonPhraseResponseBuilderOverridePath = new SystemProperty("reasonPhraseResponseBuilderOverridePath", "reasonPhraseResponseBuilderOverridePath");
    @Rule
    public SystemProperty statusReasonPhraseResponseBuilderWontOverridePath = new SystemProperty("statusReasonPhraseResponseBuilderWontOverridePath", "statusReasonPhraseResponseBuilderWontOverridePath");
    @Rule
    public SystemProperty headerResponseBuilderPath = new SystemProperty("headerResponseBuilderPath", "headerResponseBuilderPath");
    @Rule
    public SystemProperty headersResponseBuilderPath = new SystemProperty("headersResponseBuilderPath", "headersResponseBuilderPath");
    @Rule
    public SystemProperty headerDuplicatesResponseBuilderPath = new SystemProperty("headerDuplicatesResponseBuilderPath", "headerDuplicatesResponseBuilderPath");
    @Rule
    public SystemProperty errorEmptyResponseBuilderPath = new SystemProperty("emptyResponseBuilderPath", "emptyResponseBuilderPath");
    @Rule
    public SystemProperty errorStatusResponseBuilderPath = new SystemProperty("statusResponseBuilderPath", "statusResponseBuilderPath");
    @Rule
    public SystemProperty errorHeaderResponseBuilderPath = new SystemProperty("headerResponseBuilderPath", "headerResponseBuilderPath");
    @Rule
    public SystemProperty errorHeadersResponseBuilderPath = new SystemProperty("headersResponseBuilderPath", "headersResponseBuilderPath");
    @Rule
    public SystemProperty errorHeaderDuplicatesResponseBuilderPath = new SystemProperty("headerDuplicatesResponseBuilderPath", "headerDuplicatesResponseBuilderPath");
    @Rule
    public SystemProperty responseBuilderAndErrorResponseBuilderNotTheSamePath = new SystemProperty("responseBuilderAndErrorResponseBuilderNotTheSamePath", "responseBuilderAndErrorResponseBuilderNotTheSamePath");
    @Rule
    public SystemProperty httpHeadersResponseBuilderPath = new SystemProperty("httpHeadersResponseBuilderPath", "httpHeadersResponseBuilderPath");

    protected String getConfigFile() {
        return "http-listener-response-builder-config.xml";
    }

    @Test
    public void emptyResponseBuilder() throws Exception {
        String url = this.getUrl(this.emptyResponseBuilderPath);
        this.emptyResponseBuilderTest(url);
    }

    @Test
    public void statusLineResponseBuilder() throws Exception {
        String url = this.getUrl(this.statusResponseBuilderPath);
        this.statusLineResponseBuilderTest(url, 201);
    }

    @Test
    public void statusLineWithCodeOverrideResponseBuilder() throws Exception {
        String url = this.getUrl(this.statusResponseBuilderOverridePath);
        this.statusLineResponseBuilderTest(url, 202);
    }

    @Test
    public void reasonPhraseResponseBuilderOverrideResponseBuilder() throws Exception {
        String url = this.getUrl(this.reasonPhraseResponseBuilderOverridePath);
        this.statusLineResponseBuilderTest(url, 200, "response success!");
    }

    @Test
    public void statusReasonPhraseResponseBuilderWontOverrideResponseBuilder() throws Exception {
        String url = this.getUrl(this.statusReasonPhraseResponseBuilderWontOverridePath);
        this.statusLineResponseBuilderTest(url, 200, "OK");
    }

    @Test
    public void headerResponseBuilder() throws Exception {
        String url = this.getUrl(this.headerResponseBuilderPath);
        this.simpleHeaderTest(url);
    }

    @Test
    public void headersResponseBuilder() throws Exception {
        String url = this.getUrl(this.headersResponseBuilderPath);
        this.simpleHeaderTest(url);
    }

    @Test
    public void headerWithDuplicatesResponseBuilder() throws Exception {
        String url = this.getUrl(this.headerDuplicatesResponseBuilderPath);
        this.headersWithDuplicatesResponseBuilderTest(url);
    }

    @Test
    public void errorEmptyResponseBuilder() throws Exception {
        String url = this.getUrl(this.errorEmptyResponseBuilderPath);
        this.emptyResponseBuilderTest(url);
    }

    @Test
    public void errorStatusLineResponseBuilder() throws Exception {
        String url = this.getUrl(this.errorStatusResponseBuilderPath);
        this.statusLineResponseBuilderTest(url, 201);
    }

    @Test
    public void errorHeaderResponseBuilder() throws Exception {
        String url = this.getUrl(this.errorHeaderResponseBuilderPath);
        this.simpleHeaderTest(url);
    }

    @Test
    public void errorHeadersResponseBuilder() throws Exception {
        String url = this.getUrl(this.errorHeadersResponseBuilderPath);
        this.simpleHeaderTest(url);
    }

    @Test
    public void errorHeaderWithDuplicatesResponseBuilder() throws Exception {
        String url = this.getUrl(this.errorHeaderDuplicatesResponseBuilderPath);
        this.headersWithDuplicatesResponseBuilderTest(url);
    }

    @Test
    public void responseBuilderIsDifferentFromErrorResponseBuilder() throws Exception {
        String url = this.getUrl(this.responseBuilderAndErrorResponseBuilderNotTheSamePath);
        Response successfulResponse = Request.Get((String)url).connectTimeout(100000).socketTimeout(10000000).execute();
        Assert.assertThat((Object)successfulResponse.returnResponse().getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)202));
        Response failureResponse = Request.Get((String)url).addHeader("FAIL", "true").connectTimeout(100000).socketTimeout(100000).execute();
        Assert.assertThat((Object)failureResponse.returnResponse().getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)505));
    }

    @Test
    public void httpHeadersResponseBuilder() throws Exception {
        String url = this.getUrl(this.httpHeadersResponseBuilderPath);
        Response response = Request.Get((String)url).connectTimeout(1000).execute();
        HttpResponse httpResponse = response.returnResponse();
        Assert.assertThat((Object)httpResponse.getFirstHeader("http.relative.path").getValue(), (Matcher)Matchers.is((Object)"relativePath"));
        Header[] requestPathHeaders = httpResponse.getHeaders("http.request.path");
        Assert.assertThat((Object)requestPathHeaders, (Matcher)Matchers.is((Matcher)Matchers.arrayWithSize((int)2)));
        Assert.assertThat((Object)requestPathHeaders[0].getValue(), (Matcher)Matchers.isOneOf((Object[])new String[]{"requestPath1", "requestPath2"}));
        Assert.assertThat((Object)requestPathHeaders[1].getValue(), (Matcher)Matchers.isOneOf((Object[])new String[]{"requestPath1", "requestPath2"}));
    }

    private String getUrl(SystemProperty pathSystemProperty) {
        return String.format("http://localhost:%s/%s", this.listenPort.getNumber(), pathSystemProperty.getValue());
    }

    private void statusLineResponseBuilderTest(String url, int expectedStatus, String expectedReasonPhrase) throws IOException {
        Response response = Request.Get((String)url).connectTimeout(1000).execute();
        HttpResponse httpResponse = response.returnResponse();
        Assert.assertThat((Object)httpResponse.getAllHeaders().length, (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)httpResponse.getFirstHeader("Content-Length").getValue(), (Matcher)Matchers.is((Object)"0"));
        Assert.assertThat((Object)httpResponse.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)expectedStatus));
        Assert.assertThat((Object)httpResponse.getStatusLine().getReasonPhrase(), (Matcher)Matchers.is((Object)expectedReasonPhrase));
    }

    private void statusLineResponseBuilderTest(String url, int expectedStatus) throws IOException {
        this.statusLineResponseBuilderTest(url, expectedStatus, "everything works!");
    }

    private void emptyResponseBuilderTest(String url) throws IOException {
        Response response = Request.Get((String)url).connectTimeout(1000).execute();
        Assert.assertThat((Object)response.returnResponse().getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)200));
    }

    private void headersWithDuplicatesResponseBuilderTest(String url) throws IOException {
        Response response = Request.Get((String)url).connectTimeout(1000).execute();
        HttpResponse httpResponse = response.returnResponse();
        Header[] userAgentHeaders = httpResponse.getHeaders("User-Agent");
        Collection headerValues = CollectionUtils.collect(Arrays.asList(userAgentHeaders), (Transformer)new Transformer(){

            public Object transform(Object input) {
                Header header = (Header)input;
                return header.getValue();
            }
        });
        Assert.assertThat((Object)userAgentHeaders.length, (Matcher)Matchers.is((Object)5));
        Assert.assertThat((Object)headerValues, (Matcher)Matchers.containsInAnyOrder((Object[])Arrays.asList("Mule 3.5.0", "Mule 3.6.0", "Mule 3.7.0", "Mule 3.8.0", "Mule 3.9.0").toArray(new String[4])));
    }

    private void simpleHeaderTest(String url) throws IOException {
        Response response = Request.Get((String)url).connectTimeout(1000).execute();
        HttpResponse httpResponse = response.returnResponse();
        Assert.assertThat((Object)httpResponse.getFirstHeader("User-Agent").getValue(), (Matcher)Matchers.is((Object)"Mule 3.6.0"));
        Assert.assertThat((Object)this.isDateValid(httpResponse.getFirstHeader("Date").getValue()), (Matcher)Matchers.is((Object)true));
    }

    public boolean isDateValid(String dateToValidate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        try {
            sdf.parse(dateToValidate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

