/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.listener;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.fluent.Request;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.StringUtils;

public abstract class HttpListenerPersistentConnectionsTestCase
extends FunctionalTestCase {
    private static final int HTTP_OK = 200;
    private static final int GET_TIMEOUT = 1000;
    @Rule
    public DynamicPort nonPersistentPort = new DynamicPort("nonPersistentPort");
    @Rule
    public DynamicPort persistentPort = new DynamicPort("persistentPort");
    @Rule
    public DynamicPort persistentPortCloseHeader = new DynamicPort("persistentPortCloseHeader");
    @Rule
    public DynamicPort persistentPortCloseProperty = new DynamicPort("persistentPortCloseProperty");
    @Rule
    public DynamicPort persistentStreamingPort = new DynamicPort("persistentStreamingPort");
    @Rule
    public DynamicPort persistentStreamingTransformerPort = new DynamicPort("persistentStreamingTransformerPort");

    protected abstract HttpVersion getHttpVersion();

    protected String getConfigFile() {
        return "http-listener-persistent-connections-config.xml";
    }

    protected void assertConnectionClosesAfterSend(DynamicPort port, HttpVersion httpVersion) throws IOException {
        Socket socket = new Socket("localhost", port.getNumber());
        this.sendRequest(socket, httpVersion);
        this.assertResponse(this.getResponse(socket), true);
        this.sendRequest(socket, httpVersion);
        this.assertResponse(this.getResponse(socket), false);
        socket.close();
    }

    protected void assertConnectionClosesAfterTimeout(DynamicPort port, HttpVersion httpVersion) throws IOException, InterruptedException {
        Socket socket = new Socket("localhost", port.getNumber());
        this.sendRequest(socket, httpVersion);
        this.assertResponse(this.getResponse(socket), true);
        this.sendRequest(socket, httpVersion);
        this.assertResponse(this.getResponse(socket), true);
        Thread.sleep(3000L);
        this.sendRequest(socket, httpVersion);
        this.assertResponse(this.getResponse(socket), false);
        socket.close();
    }

    protected void assertConnectionClosesWithRequestConnectionCloseHeader(DynamicPort port, HttpVersion httpVersion) throws IOException, InterruptedException {
        Socket socket = new Socket("localhost", port.getNumber());
        this.sendRequest(socket, httpVersion);
        this.assertResponse(this.getResponse(socket), true);
        this.sendRequest(socket, httpVersion);
        this.assertResponse(this.getResponse(socket), true);
        PrintWriter writer = new PrintWriter(socket.getOutputStream());
        writer.println("GET / " + httpVersion);
        writer.println("Host: www.example.com");
        writer.println("Connection: close");
        writer.println("");
        writer.flush();
        this.assertResponse(this.getResponse(socket), true);
        this.sendRequest(socket, httpVersion);
        this.assertResponse(this.getResponse(socket), false);
        socket.close();
    }

    protected String performRequest(int port, HttpVersion httpVersion, boolean keepAlive) throws IOException {
        HttpResponse response = this.doPerformRequest(port, httpVersion, keepAlive);
        Header connectionHeader = response.getFirstHeader("Connection");
        return connectionHeader != null ? connectionHeader.getValue() : null;
    }

    private HttpResponse doPerformRequest(int port, HttpVersion httpVersion, boolean keepAlive) throws IOException, ClientProtocolException {
        String url = String.format("http://localhost:%s/", port);
        Request request = Request.Get((String)url).version(httpVersion).connectTimeout(1000);
        if (keepAlive) {
            request = request.addHeader("Connection", "keep-alive");
        }
        HttpResponse response = request.execute().returnResponse();
        Assert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)200));
        return response;
    }

    private void assertResponse(String response, boolean shouldBeValid) {
        Assert.assertThat((Object)StringUtils.isEmpty((String)response), (Matcher)Matchers.is((Object)(!shouldBeValid ? 1 : 0)));
    }

    private void sendRequest(Socket socket, HttpVersion httpVersion) throws IOException {
        PrintWriter writer = new PrintWriter(socket.getOutputStream());
        writer.println("GET / " + httpVersion);
        writer.println("Host: www.example.com");
        writer.println("");
        writer.flush();
    }

    private String getResponse(Socket socket) {
        try {
            StringWriter writer = new StringWriter();
            BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            if (reader != null) {
                String line;
                while (!StringUtils.isEmpty((String)(line = reader.readLine()))) {
                    writer.append(line).append("\r\n");
                }
            }
            return writer.toString();
        }
        catch (IOException e) {
            return null;
        }
    }
}

