/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.listener;

import java.util.Arrays;
import java.util.Collection;
import org.apache.http.HttpEntity;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.StringEntity;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

@RunWith(value=Parameterized.class)
public class HttpListenerPathRoutingTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort listenPort = new DynamicPort("port");
    @Rule
    public SystemProperty path = new SystemProperty("path", "path");
    @Rule
    public SystemProperty path2 = new SystemProperty("path2", "path2");
    @Rule
    public SystemProperty anotherPath = new SystemProperty("anotherPath", "anotherPath");
    @Rule
    public SystemProperty pathSubPath = new SystemProperty("path/subpath", "path/subpath");
    private final String testPath;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"path"}, {"path2"}, {"anotherPath"}, {"path/subpath"});
    }

    public HttpListenerPathRoutingTestCase(String path) {
        this.testPath = path;
    }

    protected String getConfigFile() {
        return "http-listener-path-routing-config.xml";
    }

    @Test
    public void callPath() throws Exception {
        String url = String.format("http://localhost:%s/%s", this.listenPort.getNumber(), this.testPath);
        Response response = Request.Post((String)url).body((HttpEntity)new StringEntity(this.testPath)).connectTimeout(1000).execute();
        Assert.assertThat((Object)response.returnContent().asString(), (Matcher)CoreMatchers.is((Object)this.testPath));
    }
}

