/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.listener;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.fluent.Request;
import org.apache.http.message.BasicNameValuePair;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpListenerParseRequestTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort listenPort = new DynamicPort("port");
    @Rule
    public DynamicPort listenPort2 = new DynamicPort("port2");

    protected String getConfigFile() {
        return "http-listener-parse-request-config.xml";
    }

    @Test
    public void parseRequestListenerAttributeWithConfigWithoutParseRequestAttribute() throws Exception {
        this.sendUrlEncodedPost("listenerWithConfigWithParseRequestNoValue", this.listenPort.getNumber());
        this.assertMessageContains(InputStream.class);
    }

    @Test
    public void parseRequestListenerConfigWithParseRequestAttribute() throws Exception {
        this.sendUrlEncodedPost("listenerWithConfigWithParseRequestValue", this.listenPort2.getNumber());
        this.assertMessageContains(InputStream.class);
    }

    @Test
    public void parseRequestListenerOverridesListenerConfigParseRequestAttribute() throws Exception {
        this.sendUrlEncodedPost("parseRequestUsingListenerValue", this.listenPort2.getNumber());
        this.assertMessageContains(Map.class);
    }

    private void sendUrlEncodedPost(String path, int port) throws IOException {
        Request.Post((String)this.getUrl(path, port)).bodyForm(new NameValuePair[]{new BasicNameValuePair("key", "value")}).connectTimeout(5000).socketTimeout(5000).execute();
    }

    private void assertMessageContains(Class type) throws Exception {
        MuleMessage message = muleContext.getClient().request("vm://out", 5000L);
        Assert.assertThat((Object)message.getPayload(), (Matcher)IsInstanceOf.instanceOf((Class)type));
    }

    private String getUrl(String path, int port) {
        return String.format("http://localhost:%s/%s", port, path);
    }
}

