/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.listener;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.fluent.Request;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.context.MuleContextBuilder;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.context.DefaultMuleContextBuilder;
import org.mule.module.http.functional.TestConnectorMessageNotificationListener;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

public class HttpListenerNotificationsTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort listenPort = new DynamicPort("port");
    @Rule
    public SystemProperty path = new SystemProperty("path", "path");

    protected void configureMuleContext(MuleContextBuilder contextBuilder) {
        contextBuilder.setNotificationManager(TestConnectorMessageNotificationListener.register(DefaultMuleContextBuilder.createDefaultNotificationManager()));
        super.configureMuleContext(contextBuilder);
    }

    protected String getConfigFile() {
        return "http-listener-notifications-config.xml";
    }

    @Test
    public void receiveNotification() throws Exception {
        String listenerUrl = String.format("http://localhost:%s/%s", this.listenPort.getNumber(), this.path.getValue());
        CountDownLatch latch = new CountDownLatch(2);
        TestConnectorMessageNotificationListener listener = new TestConnectorMessageNotificationListener(latch, listenerUrl);
        muleContext.getNotificationManager().addListener((ServerNotificationListener)listener);
        Request.Post((String)listenerUrl).execute();
        latch.await(1000L, TimeUnit.MILLISECONDS);
        Assert.assertThat(listener.getNotificationActionNames(), (Matcher)Matchers.contains((Object[])new String[]{ServerNotification.getActionName((int)801), ServerNotification.getActionName((int)805)}));
    }
}

