/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.listener;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEvent;
import org.mule.construct.Flow;
import org.mule.module.http.api.HttpConstants;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

@RunWith(value=Parameterized.class)
public class HttpListenerMethodRoutingTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort listenPort = new DynamicPort("port");
    @Rule
    public SystemProperty path = new SystemProperty("path", "path");
    private final String method;
    private final String expectedContent;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"GET", "GET"}, {"POST", "POST"}, {"OPTIONS", "OPTIONS-DELETE"}, {"DELETE", "OPTIONS-DELETE"}, {"PUT", "ALL"});
    }

    public HttpListenerMethodRoutingTestCase(String method, String expectedContent) {
        this.method = method;
        this.expectedContent = expectedContent;
    }

    protected String getConfigFile() {
        return "http-listener-method-routing-config.xml";
    }

    @Test
    public void callWithMethod() throws Exception {
        this.sendRequestAndAssertMethod("Test Message");
        Assert.assertThat((Object)muleContext.getClient().request("vm://out", 5000L).getPayloadAsString(), (Matcher)CoreMatchers.equalTo((Object)"Test Message"));
    }

    @Test
    public void callWithMethodEmptyBody() throws Exception {
        this.sendRequestAndAssertMethod(null);
    }

    private void sendRequestAndAssertMethod(String payload) throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("requestFlow");
        MuleEvent event = HttpListenerMethodRoutingTestCase.getTestEvent((Object)payload);
        event.setFlowVariable("method", (Object)this.method);
        event = flow.process(event);
        Assert.assertThat((Object)event.getMessage().getInboundProperty("http.status"), (Matcher)Is.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        Assert.assertThat((Object)event.getMessageAsString(), (Matcher)Is.is((Object)this.expectedContent));
    }
}

