/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.listener;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.fluent.Request;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.http.api.HttpConstants;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.IOUtils;

public class HttpListenerLaxContentTypeTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort httpPort = new DynamicPort("httpPort");

    protected String getConfigFile() {
        return "http-listener-lax-content-type-config.xml";
    }

    @Test
    public void ignoresInvalidContentTypeWithoutBody() throws Exception {
        Request request = Request.Post((String)this.getUrl()).addHeader("Content-Type", "application");
        this.testIgnoreInvalidContentType(request, "{ \"key1\" : \"value, \"key2\" : 2 }");
    }

    @Test
    public void returnsInvalidContentTypeInResponse() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send(this.getUrlForIvalid(), (Object)"Test Message", null);
        this.assertInvalidContentTypeProperty(response);
    }

    private void testIgnoreInvalidContentType(Request request, String expectedMessage) throws IOException {
        HttpResponse response = request.execute().returnResponse();
        StatusLine statusLine = response.getStatusLine();
        MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent()), (Matcher)Matchers.containsString((String)expectedMessage));
        MatcherAssert.assertThat((Object)statusLine.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
    }

    private String getUrl() {
        return String.format("http://localhost:%s/testInput", this.httpPort.getValue());
    }

    private String getUrlForIvalid() {
        return String.format("http://localhost:%s/testInputInvalid", this.httpPort.getValue());
    }

    private void assertInvalidContentTypeProperty(MuleMessage response) {
        MatcherAssert.assertThat((Object)response.getInboundPropertyNames(), (Matcher)Matchers.hasItem((Matcher)Matchers.equalToIgnoringCase((String)"Content-Type")));
        MatcherAssert.assertThat((Object)((String)response.getInboundProperty("Content-Type")), (Matcher)Matchers.equalTo((Object)"invalidMimeType"));
    }
}

