/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.listener;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.http.HttpVersion;
import org.apache.http.client.fluent.Request;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.module.http.internal.ParameterMap;
import org.mule.module.http.internal.domain.HttpProtocol;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpListenerHttpMessagePropertiesTestCase
extends FunctionalTestCase {
    public static final String QUERY_PARAM_NAME = "queryParam";
    public static final String QUERY_PARAM_VALUE = "paramValue";
    public static final String QUERY_PARAM_VALUE_WITH_SPACES = "param Value";
    public static final String QUERY_PARAM_SECOND_VALUE = "paramAnotherValue";
    public static final String SECOND_QUERY_PARAM_NAME = "queryParam2";
    public static final String SECOND_QUERY_PARAM_VALUE = "paramValue2";
    public static final String CONTEXT_PATH = "/context/path";
    public static final String API_CONTEXT_PATH = "/api/context/path";
    public static final String BASE_PATH = "/";
    private static final String FIRST_URI_PARAM_NAME = "uri-param1";
    private static final String SECOND_URI_PARAM_NAME = "uri-param2";
    private static final String THIRD_URI_PARAM_NAME = "uri-param3";
    public static final String FIRST_URI_PARAM = "uri-param-value-1";
    public static final String SECOND_URI_PARAM_VALUE = "uri-param-value-2";
    public static final String THIRD_URI_PARAM_VALUE = "uri-param-value-3";
    @Rule
    public DynamicPort listenPort = new DynamicPort("port1");
    @Rule
    public DynamicPort listenBasePort = new DynamicPort("port2");

    protected String getConfigFile() {
        return "http-listener-message-properties-config.xml";
    }

    @Test
    public void get() throws Exception {
        String url = String.format("http://localhost:%s", this.listenPort.getNumber());
        Request.Get((String)url).connectTimeout(5000).execute();
        MuleMessage message = muleContext.getClient().request("vm://out", 5000L);
        Assert.assertThat((Object)message.getInboundProperty("http.request.uri"), (Matcher)CoreMatchers.is((Object)BASE_PATH));
        Assert.assertThat((Object)message.getInboundProperty("http.request.path"), (Matcher)CoreMatchers.is((Object)BASE_PATH));
        Assert.assertThat((Object)message.getInboundProperty("http.relative.path"), (Matcher)CoreMatchers.is((Object)BASE_PATH));
        Assert.assertThat((Object)message.getInboundProperty("http.query.string"), (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)message.getInboundProperty("http.uri.params"), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)((Map)message.getInboundProperty("http.uri.params")).isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        Map queryParams = (Map)message.getInboundProperty("http.query.params");
        Assert.assertThat((Object)queryParams, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)queryParams.size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)message.getInboundProperty("http.method"), (Matcher)CoreMatchers.is((Object)"GET"));
        Assert.assertThat((Object)message.getInboundProperty("http.version"), (Matcher)CoreMatchers.is((Object)HttpProtocol.HTTP_1_1.asString()));
        Assert.assertThat((Object)message.getInboundProperty("http.remote.address"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void getWithQueryParams() throws Exception {
        ImmutableMap queryParams = ImmutableMap.builder().put((Object)QUERY_PARAM_NAME, (Object)QUERY_PARAM_VALUE).put((Object)SECOND_QUERY_PARAM_NAME, (Object)SECOND_QUERY_PARAM_VALUE).build();
        String uri = "/?" + this.buildQueryString((Map<String, Object>)queryParams);
        String url = String.format("http://localhost:%s" + uri, this.listenPort.getNumber());
        Request.Get((String)url).connectTimeout(5000).execute();
        MuleMessage message = muleContext.getClient().request("vm://out", 5000L);
        Assert.assertThat((Object)message.getInboundProperty("http.request.uri"), (Matcher)CoreMatchers.is((Object)uri));
        Assert.assertThat((Object)message.getInboundProperty("http.request.path"), (Matcher)CoreMatchers.is((Object)BASE_PATH));
        Assert.assertThat((Object)message.getInboundProperty("http.relative.path"), (Matcher)CoreMatchers.is((Object)BASE_PATH));
        Map retrivedQueryParams = (Map)message.getInboundProperty("http.query.params");
        Assert.assertThat((Object)retrivedQueryParams, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)retrivedQueryParams.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat(retrivedQueryParams.get(QUERY_PARAM_NAME), (Matcher)CoreMatchers.is((Object)QUERY_PARAM_VALUE));
        Assert.assertThat(retrivedQueryParams.get(SECOND_QUERY_PARAM_NAME), (Matcher)CoreMatchers.is((Object)SECOND_QUERY_PARAM_VALUE));
    }

    @Test
    public void getWithQueryParamMultipleValues() throws Exception {
        ImmutableMap queryParams = ImmutableMap.builder().put((Object)QUERY_PARAM_NAME, Arrays.asList(QUERY_PARAM_VALUE, QUERY_PARAM_SECOND_VALUE)).build();
        String url = String.format("http://localhost:%s/?" + this.buildQueryString((Map<String, Object>)queryParams), this.listenPort.getNumber());
        Request.Get((String)url).connectTimeout(5000).execute();
        MuleMessage message = muleContext.getClient().request("vm://out", 5000L);
        ParameterMap retrivedQueryParams = (ParameterMap)message.getInboundProperty("http.query.params");
        Assert.assertThat((Object)retrivedQueryParams, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)retrivedQueryParams.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)retrivedQueryParams.get((Object)QUERY_PARAM_NAME), (Matcher)CoreMatchers.is((Object)QUERY_PARAM_SECOND_VALUE));
        Assert.assertThat((Object)retrivedQueryParams.getAll(QUERY_PARAM_NAME).size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)retrivedQueryParams.getAll(QUERY_PARAM_NAME), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{QUERY_PARAM_VALUE, QUERY_PARAM_SECOND_VALUE}));
    }

    @Test
    public void postWithEncodedValues() throws Exception {
        ImmutableMap queryParams = ImmutableMap.builder().put((Object)QUERY_PARAM_NAME, (Object)QUERY_PARAM_VALUE_WITH_SPACES).build();
        String url = String.format("http://localhost:%s/?" + this.buildQueryString((Map<String, Object>)queryParams), this.listenPort.getNumber());
        Request.Post((String)url).connectTimeout(5000).execute();
        MuleMessage message = muleContext.getClient().request("vm://out", 5000L);
        ParameterMap retrivedQueryParams = (ParameterMap)message.getInboundProperty("http.query.params");
        Assert.assertThat((Object)retrivedQueryParams, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)retrivedQueryParams.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)retrivedQueryParams.get((Object)QUERY_PARAM_NAME), (Matcher)CoreMatchers.is((Object)QUERY_PARAM_VALUE_WITH_SPACES));
    }

    @Test
    public void putWithOldProtocol() throws Exception {
        ImmutableMap queryParams = ImmutableMap.builder().put((Object)QUERY_PARAM_NAME, Arrays.asList(QUERY_PARAM_VALUE, QUERY_PARAM_VALUE)).build();
        String url = String.format("http://localhost:%s/?" + this.buildQueryString((Map<String, Object>)queryParams), this.listenPort.getNumber());
        Request.Put((String)url).version(HttpVersion.HTTP_1_0).connectTimeout(5000).execute();
        MuleMessage message = muleContext.getClient().request("vm://out", 5000L);
        Assert.assertThat((Object)message.getInboundProperty("http.method"), (Matcher)CoreMatchers.is((Object)"PUT"));
        Assert.assertThat((Object)message.getInboundProperty("http.version"), (Matcher)CoreMatchers.is((Object)HttpProtocol.HTTP_1_0.asString()));
    }

    @Test
    public void getFullUriAndPath() throws Exception {
        String url = String.format("http://localhost:%s%s", this.listenPort.getNumber(), CONTEXT_PATH);
        Request.Get((String)url).connectTimeout(5000).execute();
        MuleMessage message = muleContext.getClient().request("vm://out", 5000L);
        Assert.assertThat((Object)message.getInboundProperty("http.request.uri"), (Matcher)CoreMatchers.is((Object)CONTEXT_PATH));
        Assert.assertThat((Object)message.getInboundProperty("http.request.path"), (Matcher)CoreMatchers.is((Object)CONTEXT_PATH));
        Assert.assertThat((Object)message.getInboundProperty("http.relative.path"), (Matcher)CoreMatchers.is((Object)CONTEXT_PATH));
    }

    @Test
    public void getAllUriParams() throws Exception {
        String url = String.format("http://localhost:%s/%s/%s/%s", this.listenPort.getNumber(), FIRST_URI_PARAM, SECOND_URI_PARAM_VALUE, THIRD_URI_PARAM_VALUE);
        Request.Post((String)url).connectTimeout(5000).execute();
        MuleMessage message = muleContext.getClient().request("vm://out", 5000L);
        ParameterMap uriParams = (ParameterMap)message.getInboundProperty("http.uri.params");
        Assert.assertThat((Object)uriParams, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)uriParams.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)uriParams.get((Object)FIRST_URI_PARAM_NAME), (Matcher)CoreMatchers.is((Object)FIRST_URI_PARAM));
        Assert.assertThat((Object)uriParams.get((Object)SECOND_URI_PARAM_NAME), (Matcher)CoreMatchers.is((Object)SECOND_URI_PARAM_VALUE));
        Assert.assertThat((Object)uriParams.get((Object)THIRD_URI_PARAM_NAME), (Matcher)CoreMatchers.is((Object)THIRD_URI_PARAM_VALUE));
    }

    @Test
    public void getUriParamInTheMiddle() throws Exception {
        String url = String.format("http://localhost:%s/some-path/%s/some-other-path", this.listenPort.getNumber(), FIRST_URI_PARAM);
        Request.Post((String)url).connectTimeout(5000).execute();
        MuleMessage message = muleContext.getClient().request("vm://out", 5000L);
        ParameterMap uriParams = (ParameterMap)message.getInboundProperty("http.uri.params");
        Assert.assertThat((Object)uriParams, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)uriParams.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)uriParams.get((Object)FIRST_URI_PARAM_NAME), (Matcher)CoreMatchers.is((Object)FIRST_URI_PARAM));
    }

    @Test
    public void postUriParamEncoded() throws Exception {
        String uriParamValue = "uri param value";
        String uriParamValueEncoded = URLEncoder.encode("uri param value", Charsets.UTF_8.displayName());
        String url = String.format("http://localhost:%s/some-path/%s/some-other-path", this.listenPort.getNumber(), uriParamValueEncoded);
        Request.Post((String)url).connectTimeout(5000).execute();
        MuleMessage message = muleContext.getClient().request("vm://out", 5000L);
        ParameterMap uriParams = (ParameterMap)message.getInboundProperty("http.uri.params");
        Assert.assertThat((Object)uriParams, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)uriParams.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)uriParams.get((Object)FIRST_URI_PARAM_NAME), (Matcher)CoreMatchers.is((Object)"uri param value"));
    }

    @Test
    public void xForwardedForHeader() throws Exception {
        String url = String.format("http://localhost:%s/some-path", this.listenPort.getNumber());
        Request.Post((String)url).connectTimeout(5000).execute();
        MuleMessage message = muleContext.getClient().request("vm://out", 5000L);
        Assert.assertThat((Object)message.getInboundProperty("http.remote.address"), (Matcher)Matchers.startsWith((String)"/127.0.0.1:"));
        Assert.assertThat((Object)message.getInboundProperty("X-Forwarded-For"), (Matcher)CoreMatchers.nullValue());
        Request.Post((String)url).addHeader("X-Forwarded-For", "clientIp, proxy1Ip").connectTimeout(5000).execute();
        MuleMessage forwardedMessage = muleContext.getClient().request("vm://out", 5000L);
        Assert.assertThat((Object)forwardedMessage.getInboundProperty("http.remote.address"), (Matcher)Matchers.startsWith((String)"/127.0.0.1:"));
        Assert.assertThat((Object)forwardedMessage.getInboundProperty("X-Forwarded-For"), (Matcher)CoreMatchers.is((Object)"clientIp, proxy1Ip"));
    }

    @Test
    public void getBasePath() throws Exception {
        String url = String.format("http://localhost:%s%s", this.listenBasePort.getNumber(), API_CONTEXT_PATH);
        Request.Get((String)url).connectTimeout(5000).execute();
        MuleMessage message = muleContext.getClient().request("vm://out", 5000L);
        Assert.assertThat((Object)message.getInboundProperty("http.listener.path"), (Matcher)CoreMatchers.is((Object)"/api/*"));
        Assert.assertThat((Object)message.getInboundProperty("http.request.path"), (Matcher)CoreMatchers.is((Object)API_CONTEXT_PATH));
        Assert.assertThat((Object)message.getInboundProperty("http.relative.path"), (Matcher)CoreMatchers.is((Object)CONTEXT_PATH));
        ParameterMap uriParams = (ParameterMap)message.getInboundProperty("http.uri.params");
        Assert.assertThat((Object)uriParams, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)uriParams.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    public String buildQueryString(Map<String, Object> queryParams) throws UnsupportedEncodingException {
        StringBuilder queryString = new StringBuilder();
        for (String paramName : queryParams.keySet()) {
            Object value = queryParams.get(paramName);
            if (value instanceof Collection) {
                for (Object eachValue : (Collection)value) {
                    queryString.append(paramName + "=" + URLEncoder.encode(eachValue.toString(), Charset.defaultCharset().name()));
                    queryString.append("&");
                }
                continue;
            }
            queryString.append(paramName + "=" + URLEncoder.encode(value.toString(), Charset.defaultCharset().name()));
            queryString.append("&");
        }
        queryString.deleteCharAt(queryString.length() - 1);
        return queryString.toString();
    }
}

