/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.listener;

import java.io.InputStream;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.util.IOUtils;

public class HttpListenerHeaderCaseTestCase
extends FunctionalTestCase {
    public static final String HEADER_VALUE = "customValue";
    @Rule
    public DynamicPort port = new DynamicPort("port");
    @Rule
    public SystemProperty headerCaseProperty = new SystemProperty("org.glassfish.grizzly.http.PRESERVE_HEADER_CASE", Boolean.TRUE.toString());

    protected String getConfigFile() {
        return "http-listener-header-case-config.xml";
    }

    @Test
    public void sendsAndReceivesHeaderWithSameCase() throws Exception {
        String url = String.format("http://localhost:%s/test", this.port.getNumber());
        Response response = Request.Get((String)url).setHeader("CusTomName", HEADER_VALUE).connectTimeout(5000).execute();
        HttpResponse httpResponse = response.returnResponse();
        Assert.assertThat((Object)IOUtils.toString((InputStream)httpResponse.getEntity().getContent()), (Matcher)Is.is((Object)Boolean.TRUE.toString()));
        Assert.assertThat((Object)httpResponse.getFirstHeader("CusTomName").getValue(), (Matcher)Is.is((Object)HEADER_VALUE));
    }
}

