/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.listener;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

public class HttpListenerGlobalResponseBuilderTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort listenPort = new DynamicPort("port");
    @Rule
    public SystemProperty globalResponseBuilderPath = new SystemProperty("globalResponseBuilderPath", "globalResponseBuilderPath");
    @Rule
    public SystemProperty globalResponseBuilderCustomizedPath = new SystemProperty("globalResponseBuilderCustomizedPath", "globalResponseBuilderCustomizedPath");
    @Rule
    public SystemProperty globalCompositeResponseBuilderPath = new SystemProperty("globalCompositeResponseBuilderPath", "globalCompositeResponseBuilderPath");

    protected String getConfigFile() {
        return "http-listener-response-builder-global-config.xml";
    }

    @Test
    public void globalResponseBuilder() throws Exception {
        String url = String.format("http://localhost:%s/%s", this.listenPort.getNumber(), this.globalResponseBuilderPath.getValue());
        this.testResponseHeaders(url, Arrays.asList("Mule 3.6.0"));
    }

    @Test
    public void globalResponseBuilderCustomized() throws Exception {
        String url = String.format("http://localhost:%s/%s", this.listenPort.getNumber(), this.globalResponseBuilderCustomizedPath.getValue());
        this.testResponseHeaders(url, Arrays.asList("Mule 3.6.0", "Mule 3.7.0"));
    }

    @Test
    public void globalCompositeResponseBuilder() throws Exception {
        String url = String.format("http://localhost:%s/%s", this.listenPort.getNumber(), this.globalCompositeResponseBuilderPath.getValue());
        this.testResponseHeaders(url, Arrays.asList("Mule 3.6.0", "Mule 3.7.0", "Mule 3.8.0"));
    }

    private void testResponseHeaders(String url, Collection<String> userAgentHeaderValues) throws IOException {
        Response response = Request.Get((String)url).connectTimeout(1000).execute();
        HttpResponse httpResponse = response.returnResponse();
        Assert.assertThat((Object)this.isDateValid(httpResponse.getFirstHeader("Date").getValue()), (Matcher)Is.is((Object)true));
        Header[] userAgentHeaders = httpResponse.getHeaders("User-Agent");
        Collection headerValues = CollectionUtils.collect(Arrays.asList(userAgentHeaders), (Transformer)new Transformer(){

            public Object transform(Object input) {
                Header header = (Header)input;
                return header.getValue();
            }
        });
        Assert.assertThat((Object)userAgentHeaders.length, (Matcher)CoreMatchers.is((Object)userAgentHeaderValues.size()));
        Assert.assertThat((Object)headerValues, (Matcher)Matchers.containsInAnyOrder((Object[])userAgentHeaderValues.toArray(new String[userAgentHeaderValues.size()])));
    }

    public boolean isDateValid(String dateToValidate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        try {
            sdf.parse(dateToValidate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

