/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.listener;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.module.http.api.HttpConstants;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.util.IOUtils;

@RunWith(value=Parameterized.class)
public class HttpListenerExpectHeaderStreamingNeverTestCase
extends FunctionalTestCase {
    private static final String HTTP_11 = "HTTP/1.1";
    private static final String LISTEN_HOST = "localhost";
    private static final String CONTINUE_RESPONSE = "HTTP/1.1 100 Continue\r\n\r\n";
    private static final String EXPECTATION_FAILED_RESPONSE = "HTTP/1.1 417 Expectation Failed\r\n";
    @Rule
    public DynamicPort listenPort = new DynamicPort("port");
    @Rule
    public SystemProperty persistentConnections;
    private Socket socket;
    private InputStream inputStream;
    private OutputStream outputStream;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({Boolean.TRUE.toString()}, {Boolean.FALSE.toString()});
    }

    protected String getConfigFile() {
        return "http-listener-expect-header-streaming-never-config.xml";
    }

    public HttpListenerExpectHeaderStreamingNeverTestCase(String persistentConnections) {
        this.persistentConnections = new SystemProperty("persistentConnections", persistentConnections);
    }

    @Before
    public void setup() throws IOException {
        this.socket = new Socket();
        this.socket.connect(new InetSocketAddress(LISTEN_HOST, this.listenPort.getNumber()));
        this.outputStream = this.socket.getOutputStream();
        this.inputStream = this.socket.getInputStream();
    }

    @After
    public void tearDown() throws Exception {
        this.outputStream.close();
        this.inputStream.close();
        this.socket.close();
    }

    @Test
    public void http11WithoutExpectHeader() throws Exception {
        this.sendAndReceiveWithoutExpectContinue();
        if (this.isPersistentConnections()) {
            this.sendAndReceiveWithoutExpectContinue();
        }
    }

    @Test
    public void http11WithExpectHeader() throws Exception {
        this.sendHeaders(this.outputStream, HTTP_11, "100-continue");
        this.readAndAssertContinueResponse(this.inputStream);
        this.sendBody(this.outputStream);
        this.readAndAssertResponse(this.inputStream);
        if (this.isPersistentConnections()) {
            this.sendAndReceiveWithoutExpectContinue();
        }
    }

    @Test
    public void http11WithExpectHeaderInvalidValue() throws Exception {
        this.sendHeaders(this.outputStream, HTTP_11, "invalidExpect");
        this.assertFromStream(this.inputStream, EXPECTATION_FAILED_RESPONSE);
    }

    private void sendAndReceiveWithoutExpectContinue() throws IOException {
        this.sendHeaders(this.outputStream, HTTP_11, null);
        this.sendBody(this.outputStream);
        this.readAndAssertResponse(this.inputStream);
    }

    private boolean isPersistentConnections() throws IOException {
        return Boolean.parseBoolean(this.persistentConnections.getValue());
    }

    private void sendHeaders(OutputStream outputStream, String httpVersion, String expectHeaderValue) throws IOException {
        String request = String.format("%s / %s\n%s: %s\n%s: %d\n", HttpConstants.Methods.POST.name(), httpVersion, "Host", LISTEN_HOST, "Content-Length", "Test Message".length());
        if (expectHeaderValue != null) {
            request = request + String.format("%s: %s\n", "Expect", expectHeaderValue);
        }
        request = request + "\n";
        outputStream.write(request.getBytes());
        outputStream.flush();
    }

    private void sendBody(OutputStream outputStream) throws IOException {
        outputStream.write("Test Message".getBytes());
        outputStream.flush();
    }

    private void readAndAssertContinueResponse(InputStream inputStream) throws IOException {
        this.assertFromStream(inputStream, CONTINUE_RESPONSE);
    }

    private void readAndAssertResponse(InputStream inputStream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream), 1);
        while (!reader.readLine().isEmpty()) {
        }
        char[] body = new char[this.getExpectedResponseBody().length()];
        IOUtils.read((Reader)reader, (char[])body);
        Assert.assertThat((Object)new String(body), (Matcher)CoreMatchers.equalTo((Object)this.getExpectedResponseBody()));
    }

    private void assertFromStream(InputStream inputStream, String expectedInput) throws IOException {
        byte[] actualInput = new byte[expectedInput.length()];
        IOUtils.read((InputStream)inputStream, (byte[])actualInput);
        Assert.assertThat((Object)new String(actualInput), (Matcher)CoreMatchers.equalTo((Object)expectedInput));
    }

    protected String getExpectedResponseBody() {
        return "Test Message";
    }
}

