/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.listener;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

@RunWith(value=Parameterized.class)
public class HttpListenerEncodingTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort port = new DynamicPort("port");
    private static final String JAPANESE_MESSAGE = "\u3042";
    private static final String ARABIC_MESSAGE = "\u0634";
    private static final String CYRILLIC_MESSAGE = "\u0416";
    private static final String SIMPLE_MESSAGE = "A";
    @Parameterized.Parameter(value=0)
    public String encoding;
    @Parameterized.Parameter(value=1)
    public String testMessage;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"EUC-JP", JAPANESE_MESSAGE}, {"Windows-31J", JAPANESE_MESSAGE}, {"ISO-2022-JP", JAPANESE_MESSAGE}, {"UTF-8", JAPANESE_MESSAGE}, {"Arabic", ARABIC_MESSAGE}, {"Windows-1256", ARABIC_MESSAGE}, {"Windows-1251", CYRILLIC_MESSAGE}, {"Cyrillic", CYRILLIC_MESSAGE}, {"US-ASCII", SIMPLE_MESSAGE});
    }

    protected String getConfigFile() {
        return "http-listener-encoding-config.xml";
    }

    @Test
    public void testEncoding() throws Exception {
        String url = String.format("http://localhost:%s/test", this.port.getNumber());
        Request request = Request.Post((String)url).bodyString(this.testMessage, ContentType.create((String)"text/plain", (Charset)Charset.forName(this.encoding)));
        request.execute();
        MuleMessage result = muleContext.getClient().request("vm://out", 2000L);
        Assert.assertThat((Object)result.getPayloadAsString(), (Matcher)Matchers.is((Object)this.testMessage));
    }
}

