/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.listener;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.StringEntity;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.http.api.HttpConstants;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.util.IOUtils;

public class HttpListenerContentTypeTestCase
extends FunctionalTestCase {
    private static final String EXPECTED_CONTENT_TYPE = "application/json; charset=UTF-8";
    @Rule
    public SystemProperty strictContentType = new SystemProperty("mule.strictContentType", Boolean.TRUE.toString());
    @Rule
    public DynamicPort httpPort = new DynamicPort("httpPort");

    protected String getConfigFile() {
        return "http-listener-content-type-config.xml";
    }

    @Test
    public void returnsContentTypeInResponse() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send(this.getUrl(), (Object)"Test Message", null);
        this.assertContentTypeProperty(response);
    }

    @Test
    public void rejectsInvalidContentTypeWithoutBody() throws Exception {
        Request request = Request.Post((String)this.getUrl()).addHeader("Content-Type", "application");
        this.testRejectContentType(request, "Invalid Content-Type");
    }

    @Test
    public void rejectsInvalidContentTypeWithBody() throws Exception {
        Request request = Request.Post((String)this.getUrl()).body((HttpEntity)new StringEntity("Test Message", "application", null));
        this.testRejectContentType(request, "Could not parse");
    }

    private void testRejectContentType(Request request, String expectedMessage) throws IOException {
        HttpResponse response = request.execute().returnResponse();
        StatusLine statusLine = response.getStatusLine();
        MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent()), (Matcher)Matchers.containsString((String)expectedMessage));
        MatcherAssert.assertThat((Object)statusLine.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode()));
        MatcherAssert.assertThat((Object)statusLine.getReasonPhrase(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.BAD_REQUEST.getReasonPhrase()));
    }

    private String getUrl() {
        return String.format("http://localhost:%s/testInput", this.httpPort.getValue());
    }

    private void assertContentTypeProperty(MuleMessage response) {
        MatcherAssert.assertThat((Object)response.getInboundPropertyNames(), (Matcher)Matchers.hasItem((Matcher)Matchers.equalToIgnoringCase((String)"Content-Type")));
        MatcherAssert.assertThat((Object)((String)response.getInboundProperty("Content-Type")), (Matcher)Matchers.equalTo((Object)EXPECTED_CONTENT_TYPE));
    }
}

