/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.mule.api.context.notification.EndpointMessageNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.context.notification.ConnectorMessageNotification;
import org.mule.context.notification.ServerNotificationManager;
import org.mule.util.CollectionUtils;

public class TestConnectorMessageNotificationListener
implements ServerNotificationListener<ConnectorMessageNotification> {
    private final CountDownLatch latch;
    private final String expectedExchangePoint;
    private List<ConnectorMessageNotification> notifications = new ArrayList<ConnectorMessageNotification>();

    public TestConnectorMessageNotificationListener() {
        this.latch = null;
        this.expectedExchangePoint = null;
    }

    public TestConnectorMessageNotificationListener(CountDownLatch latch, String expectedExchangePoint) {
        this.latch = latch;
        this.expectedExchangePoint = expectedExchangePoint;
    }

    public void onNotification(ConnectorMessageNotification notification) {
        this.notifications.add(notification);
        if (this.latch != null) {
            Assert.assertThat((Object)notification.getEndpoint(), (Matcher)Matchers.is((Object)this.expectedExchangePoint));
            this.latch.countDown();
        }
    }

    public List<String> getNotificationActionNames() {
        return (List)CollectionUtils.collect(this.notifications, (Transformer)new Transformer(){

            public Object transform(Object input) {
                return ((ConnectorMessageNotification)input).getActionName();
            }
        });
    }

    public List<ConnectorMessageNotification> getNotifications(final String actionName) {
        return (List)CollectionUtils.select(this.notifications, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return ((ConnectorMessageNotification)object).getActionName().equals(actionName);
            }
        });
    }

    public static ServerNotificationManager register(ServerNotificationManager serverNotificationManager) {
        Map mapping = serverNotificationManager.getInterfaceToTypes();
        if (!mapping.containsKey(EndpointMessageNotificationListener.class)) {
            serverNotificationManager.addInterfaceToType(TestConnectorMessageNotificationListener.class, ConnectorMessageNotification.class);
            serverNotificationManager.addListener((ServerNotificationListener)new TestConnectorMessageNotificationListener());
        }
        return serverNotificationManager;
    }
}

