/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional;

import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.client.OperationOptions;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.transport.ssl.DefaultTlsContextFactory;
import org.mule.transport.ssl.api.TlsContextFactory;

public class HttpRestrictedCiphersAndProtocolsTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort port1 = new DynamicPort("port1");
    @Rule
    public DynamicPort port2 = new DynamicPort("port2");
    @Rule
    public DynamicPort port3 = new DynamicPort("port3");
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public SystemProperty cipherSuites = new SystemProperty("cipherSuites", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA");
    @Rule
    public SystemProperty protocol = new SystemProperty("protocol", "HTTPS");
    private HttpRequestOptionsBuilder optionsBuilder = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name());
    private DefaultTlsContextFactory tlsContextFactory;

    protected String getConfigFile() {
        return "http-restricted-ciphers-and-protocols-config.xml";
    }

    @Before
    public void setUp() throws IOException {
        this.tlsContextFactory = new DefaultTlsContextFactory();
        this.tlsContextFactory.setTrustStorePath("tls/trustStore");
        this.tlsContextFactory.setTrustStorePassword("mulepassword");
    }

    @Test
    public void worksWithProtocolAndCipherSuiteMatch() throws Exception {
        MuleEvent response = this.runFlow("12Client12Server", "test");
        Assert.assertThat((Object)response.getMessage().getPayloadAsString(), (Matcher)Matchers.is((Object)"test"));
    }

    @Test
    public void worksWithProtocolMatch() throws Exception {
        HttpRequestOptions requestOptions = this.optionsBuilder.tlsContextFactory((TlsContextFactory)this.tlsContextFactory).build();
        MuleMessage response = muleContext.getClient().send(String.format("https://localhost:%s", this.port1.getValue()), this.getTestMuleMessage("test"), (OperationOptions)requestOptions);
        Assert.assertThat((Object)response.getPayloadAsString(), (Matcher)Matchers.is((Object)"test"));
    }

    @Test
    public void worksWithCipherSuiteMatch() throws Exception {
        this.tlsContextFactory.setEnabledCipherSuites(this.cipherSuites.getValue());
        HttpRequestOptions requestOptions = this.optionsBuilder.tlsContextFactory((TlsContextFactory)this.tlsContextFactory).build();
        MuleMessage response = muleContext.getClient().send(String.format("https://localhost:%s", this.port3.getValue()), this.getTestMuleMessage("test"), (OperationOptions)requestOptions);
        Assert.assertThat((Object)response.getPayloadAsString(), (Matcher)Matchers.is((Object)"test"));
    }

    @Test
    public void failsWithProtocolMismatch() throws Exception {
        this.expectedException.expectCause(Matchers.isA(IOException.class));
        this.runFlow("12Client1Server", "test");
    }

    @Test
    public void failsWithCipherSuiteMismatch() throws Exception {
        this.expectedException.expectCause(Matchers.isA(IOException.class));
        this.runFlow("12CipherClient1CipherServer", "test");
    }
}

