/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional;

import java.util.HashSet;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.module.http.internal.ParameterMap;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

public class HttpHeaderCaseTestCase
extends FunctionalTestCase {
    public static final String PRESERVE_HEADER_CASE = "org.glassfish.grizzly.http.PRESERVE_HEADER_CASE";
    public static final String HEADER_NAME = "CusTomName";
    @Rule
    public DynamicPort port = new DynamicPort("port");
    @Rule
    public SystemProperty headerCaseProperty = new SystemProperty("org.glassfish.grizzly.http.PRESERVE_HEADER_CASE", "true");

    protected String getConfigFile() {
        return "http-header-case-config.xml";
    }

    @Test
    public void worksPreservingHeaders() throws Exception {
        MuleEvent response = this.runFlow("client");
        Object payload = response.getMessage().getPayload();
        Assert.assertThat((Object)payload, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(ParameterMap.class)));
        Assert.assertThat((Object)((ParameterMap)payload), (Matcher)Matchers.hasEntry((Object)"key", (Object)"value"));
        Assert.assertThat((Object)((String)response.getMessage().getInboundProperty("Content-Type")), (Matcher)Matchers.is((Object)"application/x-www-form-urlencoded"));
        Assert.assertThat((Object)((String)response.getMessage().getInboundProperty("User-Agent")), (Matcher)Matchers.is((Object)"Mule 3.9.0"));
        Assert.assertThat((Object)((String)response.getMessage().getInboundProperty("customname1")), (Matcher)Matchers.is((Object)"customValue"));
        Assert.assertThat((Object)((String)response.getMessage().getInboundProperty(HEADER_NAME)), (Matcher)Matchers.is((Object)"CustomValue"));
    }

    public static class InboundPropertyCaseMessageProcessor
    implements MessageProcessor {
        public MuleEvent process(MuleEvent event) throws MuleException {
            MuleMessage message = event.getMessage();
            HashSet inboundPropertyNames = new HashSet(message.getInboundPropertyNames());
            message.setPayload((Object)String.valueOf(inboundPropertyNames.contains(HttpHeaderCaseTestCase.HEADER_NAME)));
            return event;
        }
    }
}

