/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.ServerSocket;
import java.net.Socket;
import org.junit.Rule;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.IOUtils;
import org.mule.util.concurrent.Latch;

public abstract class AbstractHttpExpectHeaderServerTestCase
extends FunctionalTestCase {
    private static final String CONTINUE_RESPONSE = "HTTP/1.1 100 Continue\r\n\r\n";
    private static final String EXPECTATION_FAILED_RESPONSE = "HTTP/1.1 417 Expectation Failed\r\n";
    @Rule
    public DynamicPort listenPort = new DynamicPort("httpPort");
    protected String requestBody;
    private AbstractMockServer server;

    protected void startExpectContinueServer() {
        this.server = new ExpectContinueMockServer();
        this.server.start();
    }

    protected void startExpectFailedServer() {
        this.server = new ExpectFailedMockServer();
        this.server.start();
    }

    protected void stopServer() {
        this.server.stop();
    }

    private class ExpectFailedMockServer
    extends AbstractMockServer {
        private ExpectFailedMockServer() {
        }

        @Override
        protected void process(BufferedReader reader, BufferedWriter writer) throws IOException {
            writer.write(AbstractHttpExpectHeaderServerTestCase.EXPECTATION_FAILED_RESPONSE);
            writer.flush();
        }
    }

    private class ExpectContinueMockServer
    extends AbstractMockServer {
        private ExpectContinueMockServer() {
        }

        @Override
        protected void process(BufferedReader reader, BufferedWriter writer) throws IOException {
            writer.write(AbstractHttpExpectHeaderServerTestCase.CONTINUE_RESPONSE);
            writer.flush();
            char[] body = new char["Test Message".length()];
            IOUtils.read((Reader)reader, (char[])body);
            AbstractHttpExpectHeaderServerTestCase.this.requestBody = new String(body);
            String response = String.format("HTTP/1.1 200 OK\nContent-Length: %d\n\n%s", "Test Message".length(), "Test Message");
            writer.write(response);
            writer.flush();
        }
    }

    private abstract class AbstractMockServer
    implements Runnable {
        private Latch startedLatch = new Latch();
        private Latch finishedLatch = new Latch();

        private AbstractMockServer() {
        }

        public void start() {
            try {
                Thread serverThread = new Thread(this);
                serverThread.start();
                this.startedLatch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Failed to start mock server", e);
            }
        }

        public void stop() {
            try {
                this.finishedLatch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Failed to stop mock server", e);
            }
        }

        @Override
        public void run() {
            try {
                ServerSocket serverSocket = new ServerSocket(AbstractHttpExpectHeaderServerTestCase.this.listenPort.getNumber());
                this.startedLatch.release();
                Socket socket = serverSocket.accept();
                InputStream inputStream = socket.getInputStream();
                OutputStream outputStream = socket.getOutputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream), 1);
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream), 1);
                while (!reader.readLine().isEmpty()) {
                }
                this.process(reader, writer);
                reader.close();
                writer.close();
                socket.close();
                serverSocket.close();
                this.finishedLatch.release();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        protected abstract void process(BufferedReader var1, BufferedWriter var2) throws IOException;
    }
}

