/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.api.requester.proxy;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.mule.module.http.api.requester.proxy.ProxyConfig;
import org.mule.module.http.api.requester.proxy.ProxyConfigBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class ProxyConfigBuilderTest
extends AbstractMuleTestCase {
    public static final String HOST = "host";
    public static final int PORT = 8080;
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    private ProxyConfigBuilder proxyConfigBuilder = new ProxyConfigBuilder();

    @Test(expected=IllegalArgumentException.class)
    public void onlyHost() {
        this.proxyConfigBuilder.setHost(HOST).build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void onlyPort() {
        this.proxyConfigBuilder.setPort(8080).build();
    }

    @Test
    public void minimalConfig() {
        ProxyConfig config = this.proxyConfigBuilder.setHost(HOST).setPort(8080).build();
        Assert.assertThat((Object)config.getHost(), (Matcher)Is.is((Object)HOST));
        Assert.assertThat((Object)config.getPort(), (Matcher)Is.is((Object)8080));
        Assert.assertThat((Object)config.getPassword(), (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)config.getUsername(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void fullConfig() {
        ProxyConfig config = this.proxyConfigBuilder.setHost(HOST).setPort(8080).setUsername(USERNAME).setPassword(PASSWORD).build();
        Assert.assertThat((Object)config.getHost(), (Matcher)Is.is((Object)HOST));
        Assert.assertThat((Object)config.getPort(), (Matcher)Is.is((Object)8080));
        Assert.assertThat((Object)config.getPassword(), (Matcher)Is.is((Object)PASSWORD));
        Assert.assertThat((Object)config.getUsername(), (Matcher)Is.is((Object)USERNAME));
    }
}

