/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.api.requester;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.module.http.api.HttpAuthentication;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.requester.HttpRequesterConfigBuilder;
import org.mule.module.http.api.requester.HttpSendBodyMode;
import org.mule.module.http.api.requester.HttpStreamingType;
import org.mule.module.http.api.requester.proxy.ProxyConfig;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transport.ssl.api.TlsContextFactory;

@SmallTest
public class HttpRequesterConfigBuilderTestCase
extends AbstractMuleTestCase {
    public static final String AN_EXPRESSION = "myExpression";
    public static final String HOST = "anyHost";
    public static final int PORT = 9090;
    private MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private TlsContextFactory mockTlsContext = (TlsContextFactory)Mockito.mock(TlsContextFactory.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private HttpAuthentication mockAuthentication = (HttpAuthentication)Mockito.mock(HttpAuthentication.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private ProxyConfig mockProxyConfig = (ProxyConfig)Mockito.mock(ProxyConfig.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private HttpRequesterConfigBuilder builder = new HttpRequesterConfigBuilder(this.mockMuleContext);

    @Before
    public void setUp() {
        Mockito.when((Object)this.mockMuleContext.getRegistry().get(Mockito.anyString())).thenReturn(null);
    }

    @Test
    public void responseTimeout() throws Exception {
        int responseTimeout = 100;
        Assert.assertThat((Object)this.builder.setResponseTimeout(responseTimeout).build().getResponseTimeout(), (Matcher)Is.is((Object)String.valueOf(responseTimeout)));
    }

    @Test
    public void responseTimeoutExpression() throws Exception {
        Assert.assertThat((Object)this.builder.setResponseTimeoutExpression(AN_EXPRESSION).build().getResponseTimeout(), (Matcher)Is.is((Object)AN_EXPRESSION));
    }

    @Test(expected=MuleException.class)
    public void tlsContextWithoutHttps() throws Exception {
        Assert.assertThat((Object)this.builder.setTlsContext(this.mockTlsContext).build().getTlsContext(), (Matcher)Is.is((Object)this.mockTlsContext));
    }

    @Test
    public void tlsContext() throws Exception {
        Assert.assertThat((Object)this.builder.setProtocol(HttpConstants.Protocols.HTTPS).setTlsContext(this.mockTlsContext).build().getTlsContext(), (Matcher)Is.is((Object)this.mockTlsContext));
    }

    @Test
    public void basicAuthentication() throws Exception {
        Assert.assertThat((Object)this.builder.setAuthentication(this.mockAuthentication).build().getAuthentication(), (Matcher)Is.is((Object)this.mockAuthentication));
    }

    @Test
    public void proxy() throws Exception {
        Mockito.when((Object)this.mockProxyConfig.getHost()).thenReturn((Object)HOST);
        Mockito.when((Object)this.mockProxyConfig.getPort()).thenReturn((Object)9090);
        Assert.assertThat((Object)this.builder.setProxyConfig(this.mockProxyConfig).build().getProxyConfig(), (Matcher)Is.is((Object)this.mockProxyConfig));
    }

    @Test
    public void sendBodyMode() throws Exception {
        Assert.assertThat((Object)this.builder.setSendBodyMode(HttpSendBodyMode.ALWAYS).build().getSendBodyMode(), (Matcher)Is.is((Object)HttpSendBodyMode.ALWAYS.name()));
    }

    @Test
    public void sendBodyModeExpression() throws Exception {
        Assert.assertThat((Object)this.builder.setSendBodyModeExpression(AN_EXPRESSION).build().getSendBodyMode(), (Matcher)Is.is((Object)AN_EXPRESSION));
    }

    @Test
    public void setRequestStreamingMode() throws Exception {
        Assert.assertThat((Object)this.builder.setRequestStreamingMode(HttpStreamingType.AUTO).build().getRequestStreamingMode(), (Matcher)Is.is((Object)HttpStreamingType.AUTO.name()));
    }

    @Test
    public void setRequestStreamingModeExpression() throws Exception {
        Assert.assertThat((Object)this.builder.setRequestStreamingModeExpression(AN_EXPRESSION).build().getRequestStreamingMode(), (Matcher)Is.is((Object)AN_EXPRESSION));
    }

    @Test
    public void parseResponse() throws Exception {
        Assert.assertThat((Object)this.builder.setParseResponse(true).build().getParseResponse(), (Matcher)Is.is((Object)"true"));
    }

    @Test
    public void parseResponseExpression() throws Exception {
        Assert.assertThat((Object)this.builder.setParseResponseExpression(AN_EXPRESSION).build().getParseResponse(), (Matcher)Is.is((Object)AN_EXPRESSION));
    }

    @Test
    public void host() throws Exception {
        Assert.assertThat((Object)this.builder.setHostExpression(HOST).build().getHost(), (Matcher)Is.is((Object)HOST));
    }

    @Test
    public void port() throws Exception {
        Assert.assertThat((Object)this.builder.setPort(9090).build().getPort(), (Matcher)Is.is((Object)String.valueOf(9090)));
    }

    @Test
    public void portExpression() throws Exception {
        Assert.assertThat((Object)this.builder.setPortExpression(AN_EXPRESSION).build().getPort(), (Matcher)Is.is((Object)String.valueOf(AN_EXPRESSION)));
    }
}

