/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.request.grizzly;

import org.mule.module.http.api.requester.proxy.ProxyConfig;
import org.mule.transport.ssl.api.TlsContextFactory;
import org.mule.transport.tcp.TcpClientSocketProperties;

public class GrizzlyHttpClientConfiguration {
    private final TlsContextFactory tlsContextFactory;
    private final ProxyConfig proxyConfig;
    private final TcpClientSocketProperties clientSocketProperties;
    private final int maxConnections;
    private final boolean usePersistentConnections;
    private final int connectionIdleTimeout;
    private final String threadNamePrefix;

    private GrizzlyHttpClientConfiguration(TlsContextFactory tlsContextFactory, ProxyConfig proxyConfig, TcpClientSocketProperties clientSocketProperties, int maxConnections, boolean usePersistentConnections, int connectionIdleTimeout, String threadNamePrefix) {
        this.tlsContextFactory = tlsContextFactory;
        this.proxyConfig = proxyConfig;
        this.clientSocketProperties = clientSocketProperties;
        this.maxConnections = maxConnections;
        this.usePersistentConnections = usePersistentConnections;
        this.connectionIdleTimeout = connectionIdleTimeout;
        this.threadNamePrefix = threadNamePrefix;
    }

    public TlsContextFactory getTlsContextFactory() {
        return this.tlsContextFactory;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public TcpClientSocketProperties getClientSocketProperties() {
        return this.clientSocketProperties;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public boolean isUsePersistentConnections() {
        return this.usePersistentConnections;
    }

    public int getConnectionIdleTimeout() {
        return this.connectionIdleTimeout;
    }

    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }

    public static class Builder {
        private TlsContextFactory tlsContextFactory;
        private ProxyConfig proxyConfig;
        private TcpClientSocketProperties clientSocketProperties;
        private int maxConnections;
        private boolean usePersistentConnections;
        private int connectionIdleTimeout;
        private String threadNamePrefix;

        public Builder setTlsContextFactory(TlsContextFactory tlsContextFactory) {
            this.tlsContextFactory = tlsContextFactory;
            return this;
        }

        public Builder setProxyConfig(ProxyConfig proxyConfig) {
            this.proxyConfig = proxyConfig;
            return this;
        }

        public Builder setClientSocketProperties(TcpClientSocketProperties clientSocketProperties) {
            this.clientSocketProperties = clientSocketProperties;
            return this;
        }

        public Builder setMaxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder setUsePersistentConnections(boolean usePersistentConnections) {
            this.usePersistentConnections = usePersistentConnections;
            return this;
        }

        public Builder setConnectionIdleTimeout(int connectionIdleTimeout) {
            this.connectionIdleTimeout = connectionIdleTimeout;
            return this;
        }

        public Builder setThreadNamePrefix(String threadNamePrefix) {
            this.threadNamePrefix = threadNamePrefix;
            return this;
        }

        public GrizzlyHttpClientConfiguration build() {
            return new GrizzlyHttpClientConfiguration(this.tlsContextFactory, this.proxyConfig, this.clientSocketProperties, this.maxConnections, this.usePersistentConnections, this.connectionIdleTimeout, this.threadNamePrefix);
        }
    }
}

