/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.request.grizzly;

import com.ning.http.client.AsyncHandler;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleException;
import org.mule.api.context.WorkManager;
import org.mule.module.http.internal.request.grizzly.FlowWorkManagerIOStrategy;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class FlowWorkManagerIOStrategyTestCase
extends AbstractMuleTestCase {
    FlowWorkManagerIOStrategy ioStrategy = FlowWorkManagerIOStrategy.getInstance();
    @Mock
    Connection connection;
    @Mock
    AsyncHandler asyncHandler;
    @Mock
    ExecutorService grizzlyWorkerThreadPool;
    @Mock
    WorkManager flowWorkManager;

    @Before
    public void setup() {
        AttributeHolder attributeHolder = (AttributeHolder)Mockito.mock(AttributeHolder.class);
        Mockito.when((Object)this.connection.getAttributes()).thenReturn((Object)attributeHolder);
        Transport transport = (Transport)Mockito.mock(Transport.class);
        Mockito.when((Object)this.connection.getTransport()).thenReturn((Object)transport);
        Mockito.when((Object)transport.getWorkerThreadPool()).thenReturn((Object)this.grizzlyWorkerThreadPool);
    }

    @Test
    public void flowWorkManagerUsedForReadIOEvent() throws IOException {
        new TestFlowWorkManagerIOStrategy(this.flowWorkManager).executeIoEvent(this.connection, IOEvent.READ);
        ((WorkManager)Mockito.verify((Object)this.flowWorkManager, (VerificationMode)Mockito.times((int)1))).execute((Runnable)Matchers.any(Runnable.class));
    }

    @Test
    public void grizzlyWorkThreadPoolUsedWhenNoWorkManagerForReadIOEvent() throws IOException {
        new TestFlowWorkManagerIOStrategy(null).executeIoEvent(this.connection, IOEvent.READ);
        ((ExecutorService)Mockito.verify((Object)this.grizzlyWorkerThreadPool, (VerificationMode)Mockito.times((int)1))).execute((Runnable)Matchers.any(Runnable.class));
    }

    @Test
    public void selectorUsedForConnectIOEvent() throws IOException {
        new TestFlowWorkManagerIOStrategy(this.flowWorkManager).executeIoEvent(this.connection, IOEvent.CLIENT_CONNECTED);
        ((WorkManager)Mockito.verify((Object)this.flowWorkManager, (VerificationMode)Mockito.never())).execute((Runnable)Matchers.any(Runnable.class));
        ((ExecutorService)Mockito.verify((Object)this.grizzlyWorkerThreadPool, (VerificationMode)Mockito.never())).execute((Runnable)Matchers.any(Runnable.class));
    }

    @Test
    public void selectorUsedWhenNoWorkManagerForReadEvent() throws IOException {
        new TestFlowWorkManagerIOStrategy(null).executeIoEvent(this.connection, IOEvent.CLIENT_CONNECTED);
        ((WorkManager)Mockito.verify((Object)this.flowWorkManager, (VerificationMode)Mockito.never())).execute((Runnable)Matchers.any(Runnable.class));
        ((ExecutorService)Mockito.verify((Object)this.grizzlyWorkerThreadPool, (VerificationMode)Mockito.never())).execute((Runnable)Matchers.any(Runnable.class));
    }

    class TestFlowWorkManagerIOStrategy
    extends FlowWorkManagerIOStrategy {
        private WorkManager workManager;

        TestFlowWorkManagerIOStrategy(WorkManager workManager) {
            this.workManager = workManager;
        }

        protected WorkManager getWorkManager(Connection connection) throws MuleException {
            return this.workManager;
        }
    }
}

