/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.request;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.transport.PropertyScope;
import org.mule.module.http.internal.domain.HttpEntity;
import org.mule.module.http.internal.domain.InputStreamHttpEntity;
import org.mule.module.http.internal.domain.response.HttpResponse;
import org.mule.module.http.internal.domain.response.HttpResponseBuilder;
import org.mule.module.http.internal.request.DefaultHttpRequester;
import org.mule.module.http.internal.request.HttpResponseToMuleEvent;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.util.AttributeEvaluator;
import org.mule.util.IOUtils;

public class HttpResponseToMuleEventTestCase
extends AbstractMuleContextTestCase {
    private DefaultHttpRequester httpRequester;
    private HttpResponseToMuleEvent httpResponseToMuleEvent;
    private HttpResponse httpResponse;
    private MuleEvent event;

    @Before
    public void setup() throws Exception {
        this.httpRequester = new DefaultHttpRequester();
        this.httpResponseToMuleEvent = new HttpResponseToMuleEvent(this.httpRequester, muleContext, new AttributeEvaluator("true"));
        HttpResponseBuilder builder = new HttpResponseBuilder();
        builder.setEntity((HttpEntity)new InputStreamHttpEntity((InputStream)new ByteArrayInputStream("Test Message".getBytes())));
        builder.addHeader("TestHeader", (Object)"TestValue");
        builder.setStatusCode(Integer.valueOf(200));
        builder.setReasonPhrase("OK");
        this.httpResponse = builder.build();
        this.event = HttpResponseToMuleEventTestCase.getTestEvent(null);
    }

    @Test
    public void responseHeadersAreMappedAsInboundProperties() throws MessagingException {
        this.httpResponseToMuleEvent.convert(this.event, this.httpResponse);
        Assert.assertThat((Object)((String)this.event.getMessage().getInboundProperty("TestHeader")), (Matcher)CoreMatchers.equalTo((Object)"TestValue"));
    }

    @Test
    public void previousInboundPropertiesAreRemoved() throws MessagingException {
        this.event.getMessage().setProperty("TestInboundProperty", (Object)"TestValue", PropertyScope.INBOUND);
        this.httpResponseToMuleEvent.convert(this.event, this.httpResponse);
        Assert.assertThat((Object)this.event.getMessage().getInboundProperty("TestInboundProperty"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void responseBodyIsSetAsPayload() throws MessagingException {
        this.httpResponseToMuleEvent.convert(this.event, this.httpResponse);
        InputStream responseStream = (InputStream)this.event.getMessage().getPayload();
        Assert.assertThat((Object)IOUtils.toString((InputStream)responseStream), (Matcher)CoreMatchers.equalTo((Object)"Test Message"));
    }

    @Test
    public void statusCodeIsSetAsInboundProperty() throws MessagingException {
        this.httpResponseToMuleEvent.convert(this.event, this.httpResponse);
        Assert.assertThat((Object)((Integer)this.event.getMessage().getInboundProperty("http.status")), (Matcher)CoreMatchers.equalTo((Object)200));
    }

    @Test
    public void responsePhraseIsSetAsInboundProperty() throws MessagingException {
        this.httpResponseToMuleEvent.convert(this.event, this.httpResponse);
        Assert.assertThat((Object)((String)this.event.getMessage().getInboundProperty("http.reason")), (Matcher)CoreMatchers.equalTo((Object)"OK"));
    }
}

