/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.request;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.module.http.internal.request.DefaultHttpRequester;
import org.mule.module.http.internal.request.DefaultHttpRequesterConfig;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class DefaultHttpRequesterTestCase
extends AbstractMuleContextTestCase {
    private static final String TEST_HOST = "TEST_HOST";
    private static final String TEST_PORT = "TEST_PORT";
    private DefaultHttpRequester requester = new DefaultHttpRequester();
    private DefaultHttpRequesterConfig config = new DefaultHttpRequesterConfig();

    @Before
    public void setup() {
        this.requester.setMuleContext(muleContext);
        this.config.setMuleContext(muleContext);
        this.requester.setConfig(this.config);
        this.requester.setPath("/");
    }

    @Test
    public void initializesWithHostAndPortInRequesterConfig() throws InitialisationException {
        this.config.setHost(TEST_HOST);
        this.config.setPort(TEST_PORT);
        this.requester.initialise();
        Assert.assertThat((Object)this.requester.getHost(), (Matcher)CoreMatchers.equalTo((Object)TEST_HOST));
        Assert.assertThat((Object)this.requester.getPort(), (Matcher)CoreMatchers.equalTo((Object)TEST_PORT));
    }

    @Test
    public void initializesWithHostAndPortInRequester() throws InitialisationException {
        this.requester.setHost(TEST_HOST);
        this.requester.setPort(TEST_PORT);
        this.requester.initialise();
        Assert.assertThat((Object)this.requester.getHost(), (Matcher)CoreMatchers.equalTo((Object)TEST_HOST));
        Assert.assertThat((Object)this.requester.getPort(), (Matcher)CoreMatchers.equalTo((Object)TEST_PORT));
    }

    @Test(expected=InitialisationException.class)
    public void failsToInitialiseWithoutHost() throws InitialisationException {
        this.config.setHost(null);
        this.config.setPort(TEST_PORT);
        this.requester.initialise();
    }

    @Test(expected=InitialisationException.class)
    public void failsToInitializeWithoutPort() throws InitialisationException {
        this.config.setHost(TEST_HOST);
        this.config.setPort(null);
        this.requester.initialise();
    }
}

