/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.request;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleContext;
import org.mule.api.registry.RegistrationException;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.internal.request.DefaultHttpRequesterConfig;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.transport.ssl.api.TlsContextFactory;

public class DefaultHttpRequesterConfigTestCase
extends AbstractMuleTestCase {
    private static final String LOCALHOST = "localhost";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private TlsContextFactory mockTlsContextFactory = (TlsContextFactory)Mockito.mock(TlsContextFactory.class);
    private DefaultHttpRequesterConfig requestConfig;

    @Before
    public void setUp() throws RegistrationException {
        Mockito.when((Object)this.mockTlsContextFactory.isKeyStoreConfigured()).thenReturn((Object)true);
        this.requestConfig = this.createBaseRequester();
    }

    @Test
    public void defaultPortWithDefaultProtocol() throws Exception {
        this.requestConfig.initialise();
        Assert.assertThat((Object)this.requestConfig.getPort(), (Matcher)Is.is((Object)String.valueOf(HttpConstants.Protocols.HTTP.getDefaultPort())));
    }

    @Test
    public void defaultPortWithHttpConfigured() throws Exception {
        this.requestConfig.setProtocol(HttpConstants.Protocols.HTTP);
        this.requestConfig.initialise();
        Assert.assertThat((Object)this.requestConfig.getPort(), (Matcher)Is.is((Object)String.valueOf(HttpConstants.Protocols.HTTP.getDefaultPort())));
    }

    @Test
    public void defaultPortWithHttpsConfigured() throws Exception {
        this.requestConfig.setProtocol(HttpConstants.Protocols.HTTPS);
        this.requestConfig.setTlsContext(this.mockTlsContextFactory);
        this.requestConfig.initialise();
        Assert.assertThat((Object)this.requestConfig.getPort(), (Matcher)Is.is((Object)String.valueOf(HttpConstants.Protocols.HTTPS.getDefaultPort())));
    }

    private DefaultHttpRequesterConfig createBaseRequester() {
        DefaultHttpRequesterConfig requestConfig = new DefaultHttpRequesterConfig();
        requestConfig.setHost(LOCALHOST);
        requestConfig.setMuleContext(this.mockMuleContext);
        return requestConfig;
    }
}

