/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.listener.grizzly;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.concurrent.Executor;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.IOStrategy;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.module.http.internal.listener.ServerAddress;
import org.mule.module.http.internal.listener.grizzly.ExecutorPerServerAddressIOStrategy;
import org.mule.module.http.internal.listener.grizzly.ExecutorProvider;
import org.mule.tck.junit4.AbstractMuleTestCase;

@RunWith(value=MockitoJUnitRunner.class)
public class ExecutorPerServerAddressIOStrategyTestCase
extends AbstractMuleTestCase {
    @Mock
    private ExecutorProvider executorProvider;
    @Mock
    private Connection connection;
    @Mock
    private Executor executor;
    private IOStrategy ioStrategy;

    @Before
    public void before() throws UnknownHostException {
        this.ioStrategy = new ExecutorPerServerAddressIOStrategy(this.executorProvider);
        Mockito.when((Object)this.connection.getLocalAddress()).thenReturn((Object)new InetSocketAddress(InetAddress.getLocalHost(), 80));
        Mockito.when((Object)this.executorProvider.getExecutor((ServerAddress)Mockito.any(ServerAddress.class))).thenReturn((Object)this.executor);
    }

    @Test
    public void serverAcceptIOEventDoesNotUseExecutor() {
        Assert.assertThat((Object)this.ioStrategy.getThreadPoolFor(this.connection, IOEvent.SERVER_ACCEPT), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void readIOEventUsesExecutor() {
        Assert.assertThat((Object)this.ioStrategy.getThreadPoolFor(this.connection, IOEvent.READ), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.executor)));
    }

    @Test
    public void closeIOEventUsesExecutor() {
        Assert.assertThat((Object)this.ioStrategy.getThreadPoolFor(this.connection, IOEvent.CLOSED), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.executor)));
    }
}

