/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.listener;

import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transformer.DataType;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.http.internal.domain.response.HttpResponse;
import org.mule.module.http.internal.listener.HttpMessageProcessorTemplate;
import org.mule.module.http.internal.listener.HttpResponseBuilder;
import org.mule.module.http.internal.listener.async.HttpResponseReadyCallback;
import org.mule.module.http.internal.listener.async.ResponseStatusCallback;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transport.NullPayload;

@SmallTest
public class HttpMessageProcessorTemplateTestCase
extends AbstractMuleTestCase {
    private static final int INTERNAL_SERVER_ERROR = 500;
    private static final String TEST_MESSAGE = "";

    @Test
    public void statusCodeOnFailures() throws Exception {
        MuleEvent testEvent = this.createMockEvent();
        HttpMessageProcessorTemplate httpMessageProcessorTemplate = new HttpMessageProcessorTemplate(testEvent, (MessageProcessor)Mockito.mock(MessageProcessor.class), new HttpResponseReadyCallback(){

            public void responseReady(HttpResponse response, ResponseStatusCallback responseStatusCallback) {
                Assert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)500));
            }
        }, null, HttpResponseBuilder.emptyInstance((MuleContext)((MuleContext)Mockito.mock(MuleContext.class))));
        httpMessageProcessorTemplate.sendFailureResponseToClient(new MessagingException(CoreMessages.createStaticMessage((String)TEST_MESSAGE), testEvent), null);
    }

    private MuleEvent createMockEvent() {
        MuleMessage testMessage = (MuleMessage)Mockito.mock(MuleMessage.class);
        Mockito.when((Object)testMessage.getOutboundPropertyNames()).thenReturn(Collections.emptySet());
        Mockito.when((Object)testMessage.getPayload()).thenReturn((Object)NullPayload.getInstance());
        DataType datatype = DataType.STRING_DATA_TYPE;
        Mockito.when((Object)testMessage.getDataType()).thenReturn((Object)datatype);
        MuleEvent testEvent = (MuleEvent)Mockito.mock(MuleEvent.class);
        Mockito.when((Object)testEvent.getMessage()).thenReturn((Object)testMessage);
        Mockito.when((Object)testEvent.getMuleContext()).thenReturn(Mockito.mock(MuleContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
        return testEvent;
    }
}

